/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.config.option;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.vulkanmod.config.gui.widget.OptionWidget;

public abstract class Option<T> {
    protected final class_2561 name;
    protected class_2561 tooltip;
    protected Consumer<T> onApply;
    protected Supplier<T> valueSupplier;
    protected T value;
    protected T newValue;
    protected Function<T, class_2561> translator;
    protected boolean active;
    protected Runnable onChange;

    public Option(class_2561 name, Consumer<T> setter, Supplier<T> getter, Function<T, class_2561> translator) {
        this.name = name;
        this.onApply = setter;
        this.valueSupplier = getter;
        this.value = this.valueSupplier.get();
        this.newValue = this.value;
        this.translator = translator;
    }

    public Option(class_2561 name, Consumer<T> setter, Supplier<T> getter) {
        this.name = name;
        this.onApply = setter;
        this.valueSupplier = getter;
        this.value = this.valueSupplier.get();
        this.newValue = this.value;
    }

    public Option<T> setOnApply(Consumer<T> onApply) {
        this.onApply = onApply;
        return this;
    }

    public Option<T> setValueSupplier(Supplier<T> supplier) {
        this.valueSupplier = supplier;
        return this;
    }

    public Option<T> setTranslator(Function<T, class_2561> translator) {
        this.translator = translator;
        return this;
    }

    public Option<T> setActive(boolean active) {
        this.active = active;
        return this;
    }

    public abstract OptionWidget<?> createOptionWidget(int var1, int var2, int var3, int var4);

    public void setNewValue(T t) {
        this.newValue = t;
        if (this.onChange != null) {
            this.onChange.run();
        }
    }

    public class_2561 getName() {
        return this.name;
    }

    public void setOnChange(Runnable runnable) {
        this.onChange = runnable;
    }

    public boolean isChanged() {
        return !this.newValue.equals(this.value);
    }

    public void apply() {
        if (!this.isChanged()) {
            return;
        }
        this.onApply.accept(this.newValue);
        this.value = this.newValue;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public class_2561 getDisplayedValue() {
        return this.translator.apply(this.newValue);
    }

    public Option<T> setTooltip(class_2561 text) {
        this.tooltip = text;
        return this;
    }

    public class_2561 getTooltip() {
        return this.tooltip;
    }
}

