/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.gl;

import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.vulkanmod.gl.GlUtil;
import net.vulkanmod.vulkan.texture.ImageUtil;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import net.vulkanmod.vulkan.texture.VulkanImage;
import org.lwjgl.system.MemoryUtil;

public class GlRenderbuffer {
    private static int ID_COUNTER = 1;
    private static final Int2ReferenceOpenHashMap<GlRenderbuffer> map = new Int2ReferenceOpenHashMap();
    private static int boundId = 0;
    private static GlRenderbuffer bound;
    final int id;
    VulkanImage vulkanImage;
    int internalFormat;
    boolean needsUpdate = false;
    int maxLevel = 0;
    int maxLod = 0;
    int minFilter;
    int magFilter = 9729;

    public static int genId() {
        int id = ID_COUNTER++;
        map.put(id, (Object)new GlRenderbuffer(id));
        return id;
    }

    public static void bindRenderbuffer(int target, int id) {
        boundId = id;
        bound = (GlRenderbuffer)map.get(id);
        if (id <= 0) {
            return;
        }
        if (bound == null) {
            throw new NullPointerException("bound texture is null");
        }
        VulkanImage vulkanImage = GlRenderbuffer.bound.vulkanImage;
        if (vulkanImage != null) {
            VTextureSelector.bindTexture(vulkanImage);
        }
    }

    public static void deleteRenderbuffer(int i) {
        map.remove(i);
    }

    public static GlRenderbuffer getRenderbuffer(int id) {
        return (GlRenderbuffer)map.get(id);
    }

    public static void renderbufferStorage(int target, int internalFormat, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        GlRenderbuffer.bound.internalFormat = internalFormat;
        bound.allocateIfNeeded(width, height, internalFormat);
    }

    public static void texParameteri(int target, int pName, int param) {
        if (target != 3553) {
            throw new UnsupportedOperationException();
        }
        switch (pName) {
            case 33085: {
                bound.setMaxLevel(param);
                break;
            }
            case 33083: {
                bound.setMaxLod(param);
                break;
            }
            case 33082: {
                break;
            }
            case 34049: {
                break;
            }
            case 10240: {
                bound.setMagFilter(param);
                break;
            }
            case 10241: {
                bound.setMinFilter(param);
                break;
            }
        }
    }

    public static int getTexLevelParameter(int target, int level, int pName) {
        if (bound == null || target == 3553) {
            return -1;
        }
        return switch (pName) {
            case 4099 -> GlUtil.getGlFormat(GlRenderbuffer.bound.vulkanImage.format);
            case 4096 -> GlRenderbuffer.bound.vulkanImage.width;
            case 4097 -> GlRenderbuffer.bound.vulkanImage.height;
            default -> -1;
        };
    }

    public static void generateMipmap(int target) {
        if (target != 3553) {
            throw new UnsupportedOperationException();
        }
        bound.generateMipmaps();
    }

    public static void setVulkanImage(int id, VulkanImage vulkanImage) {
        GlRenderbuffer texture = (GlRenderbuffer)map.get(id);
        texture.vulkanImage = vulkanImage;
    }

    public static GlRenderbuffer getBound() {
        return bound;
    }

    public GlRenderbuffer(int id) {
        this.id = id;
    }

    void allocateIfNeeded(int width, int height, int format) {
        int vkFormat = GlUtil.vulkanFormat(format);
        this.needsUpdate |= this.vulkanImage == null || this.vulkanImage.width != width || this.vulkanImage.height != height || vkFormat != this.vulkanImage.format;
        if (this.needsUpdate) {
            this.allocateImage(width, height, vkFormat);
            this.updateSampler();
            this.needsUpdate = false;
        }
    }

    void allocateImage(int width, int height, int vkFormat) {
        if (this.vulkanImage != null) {
            this.vulkanImage.free();
        }
        this.vulkanImage = VulkanImage.isDepthFormat(vkFormat) ? VulkanImage.createDepthImage(vkFormat, width, height, 37, false, true) : new VulkanImage.Builder(width, height).setMipLevels(this.maxLevel + 1).setFormat(vkFormat).addUsage(16).createVulkanImage();
        VTextureSelector.bindTexture(this.vulkanImage);
    }

    void updateSampler() {
        if (this.vulkanImage == null) {
            return;
        }
        byte samplerFlags = this.magFilter == 9729 ? (byte)1 : 0;
        samplerFlags = (byte)(samplerFlags | (switch (this.minFilter) {
            case 9987 -> 12;
            case 9984 -> 4;
            default -> 0;
        }));
        this.vulkanImage.updateTextureSampler(this.maxLod, samplerFlags);
    }

    private void uploadImage(ByteBuffer pixels) {
        int width = this.vulkanImage.width;
        int height = this.vulkanImage.height;
        if (this.internalFormat == 6407 && this.vulkanImage.format == 37) {
            ByteBuffer RGBA_buffer = GlUtil.RGBtoRGBA_buffer(pixels);
            this.vulkanImage.uploadSubTextureAsync(0, width, height, 0, 0, 0, 0, 0, RGBA_buffer);
            MemoryUtil.memFree((Buffer)RGBA_buffer);
        } else {
            this.vulkanImage.uploadSubTextureAsync(0, width, height, 0, 0, 0, 0, 0, pixels);
        }
    }

    void generateMipmaps() {
        ImageUtil.generateMipmaps(this.vulkanImage);
    }

    void setMaxLevel(int l) {
        if (l < 0) {
            throw new IllegalStateException("max level cannot be < 0.");
        }
        if (this.maxLevel != l) {
            this.maxLevel = l;
            this.needsUpdate = true;
        }
    }

    void setMaxLod(int l) {
        if (l < 0) {
            throw new IllegalStateException("max level cannot be < 0.");
        }
        if (this.maxLod != l) {
            this.maxLod = l;
            this.updateSampler();
        }
    }

    void setMagFilter(int v) {
        switch (v) {
            case 9728: 
            case 9729: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal mag filter value: " + v);
            }
        }
        this.magFilter = v;
        this.updateSampler();
    }

    void setMinFilter(int v) {
        switch (v) {
            case 9728: 
            case 9729: 
            case 9984: 
            case 9985: 
            case 9986: 
            case 9987: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal min filter value: " + v);
            }
        }
        this.minFilter = v;
        this.updateSampler();
    }

    public VulkanImage getVulkanImage() {
        return this.vulkanImage;
    }

    public void setVulkanImage(VulkanImage vulkanImage) {
        this.vulkanImage = vulkanImage;
    }
}

