/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.compatibility;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_277;
import net.minecraft.class_280;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_285;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import net.minecraft.class_5937;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.shader.Pipeline;
import net.vulkanmod.vulkan.shader.converter.GlslConverter;
import net.vulkanmod.vulkan.shader.descriptor.UBO;
import net.vulkanmod.vulkan.shader.layout.Uniform;
import net.vulkanmod.vulkan.util.MappedBuffer;
import org.apache.commons.io.IOUtils;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_280.class})
public class EffectInstanceM {
    @Shadow
    @Final
    private Map<String, class_284> field_1510;
    @Shadow
    @Final
    private List<class_284> field_1515;
    @Shadow
    private boolean field_1511;
    @Shadow
    private static class_280 field_1512;
    @Shadow
    @Final
    private class_277 field_1517;
    @Shadow
    private static int field_1505;
    @Shadow
    @Final
    private int field_1521;
    @Shadow
    @Final
    private List<Integer> field_1506;
    @Shadow
    @Final
    private List<String> field_1503;
    @Shadow
    @Final
    private Map<String, IntSupplier> field_1516;
    @Shadow
    @Final
    private String field_1509;
    @Unique
    private static GraphicsPipeline lastPipeline;
    @Unique
    private GraphicsPipeline pipeline;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/EffectInstance;updateLocations()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void inj(class_5912 resourceProvider, String string, CallbackInfo ci, class_2960 resourceLocation, class_3298 resource, Reader reader, JsonObject jsonObject, String string2, String string3) {
        this.createShaders(resourceProvider, string2, string3);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/EffectInstance;getOrCreate(Lnet/minecraft/server/packs/resources/ResourceProvider;Lcom/mojang/blaze3d/shaders/Program$Type;Ljava/lang/String;)Lcom/mojang/blaze3d/shaders/EffectProgram;"))
    private class_5937 redirectShader(class_5912 resourceProvider, class_281.class_282 type, String string) {
        return null;
    }

    @Overwrite
    public void close() {
        for (class_284 uniform : this.field_1515) {
            uniform.close();
        }
        this.pipeline.scheduleCleanUp();
    }

    private void createShaders(class_5912 resourceManager, String vertexShader, String fragShader) {
        try {
            String[] vshPathInfo = this.decompose(vertexShader, ':');
            class_2960 vshLocation = class_2960.method_60655((String)vshPathInfo[0], (String)("shaders/program/" + vshPathInfo[1] + ".vsh"));
            class_3298 resource = resourceManager.getResourceOrThrow(vshLocation);
            InputStream inputStream = resource.method_14482();
            String vshSrc = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            String[] fshPathInfo = this.decompose(fragShader, ':');
            class_2960 fshLocation = class_2960.method_60655((String)fshPathInfo[0], (String)("shaders/program/" + fshPathInfo[1] + ".fsh"));
            resource = resourceManager.getResourceOrThrow(fshLocation);
            inputStream = resource.method_14482();
            String fshSrc = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            GlslConverter converter = new GlslConverter();
            converter.process(vshSrc, fshSrc);
            UBO ubo = converter.createUBO();
            this.setUniformSuppliers(ubo);
            Pipeline.Builder builder = new Pipeline.Builder(class_290.field_1592, this.field_1509);
            builder.setUniforms(Collections.singletonList(ubo), converter.getSamplerList());
            builder.compileShaders(this.field_1509, converter.getVshConverted(), converter.getFshConverted());
            this.pipeline = builder.createGraphicsPipeline();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setUniformSuppliers(UBO ubo) {
        for (Uniform v_uniform : ubo.getUniforms()) {
            ByteBuffer byteBuffer;
            class_284 uniform = this.field_1510.get(v_uniform.getName());
            if (uniform.method_35662() <= 3) {
                byteBuffer = MemoryUtil.memByteBuffer((IntBuffer)uniform.method_35663());
            } else if (uniform.method_35662() <= 10) {
                byteBuffer = MemoryUtil.memByteBuffer((FloatBuffer)uniform.method_35664());
            } else {
                throw new RuntimeException("out of bounds value for uniform " + String.valueOf(uniform));
            }
            MappedBuffer mappedBuffer = MappedBuffer.createFromBuffer(byteBuffer);
            Supplier<MappedBuffer> supplier = () -> mappedBuffer;
            v_uniform.setSupplier(supplier);
        }
    }

    private String[] decompose(String string, char c) {
        String[] strings = new String[]{"minecraft", string};
        int i = string.indexOf(c);
        if (i >= 0) {
            strings[1] = string.substring(i + 1);
            if (i >= 1) {
                strings[0] = string.substring(0, i);
            }
        }
        return strings;
    }

    @Overwrite
    public void method_1277() {
        this.field_1511 = false;
        this.field_1517.method_1244();
        Renderer renderer = Renderer.getInstance();
        if (this.pipeline != lastPipeline) {
            renderer.bindGraphicsPipeline(this.pipeline);
            lastPipeline = this.pipeline;
        }
        for (int i = 0; i < this.field_1506.size(); ++i) {
            String string = this.field_1503.get(i);
            IntSupplier intSupplier = this.field_1516.get(string);
            if (intSupplier == null) continue;
            RenderSystem.activeTexture((int)(33984 + i));
            int j = intSupplier.getAsInt();
            if (j == -1) continue;
            RenderSystem.bindTexture((int)j);
            class_284.method_22095((int)this.field_1506.get(i), (int)i);
        }
        for (class_284 uniform : this.field_1515) {
            uniform.method_1300();
        }
        renderer.uploadAndBindUBOs(this.pipeline);
    }

    @Overwrite
    public void method_1273() {
        RenderSystem.assertOnRenderThread();
        class_285.method_22094((int)0);
        field_1505 = -1;
        field_1512 = null;
        lastPipeline = null;
        for (int i = 0; i < this.field_1506.size(); ++i) {
            if (this.field_1516.get(this.field_1503.get(i)) == null) continue;
            GlStateManager._activeTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
        }
    }
}

