/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.render;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.vulkanmod.Initializer;
import net.vulkanmod.interfaces.ShaderMixed;
import net.vulkanmod.render.shader.ShaderLoadUtil;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.shader.Pipeline;
import net.vulkanmod.vulkan.shader.converter.GlslConverter;
import net.vulkanmod.vulkan.shader.descriptor.UBO;
import net.vulkanmod.vulkan.shader.layout.Uniform;
import net.vulkanmod.vulkan.util.MappedBuffer;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5944.class})
public class ShaderInstanceM
implements ShaderMixed {
    @Shadow
    @Final
    private Map<String, class_284> field_29492;
    @Shadow
    @Final
    private String field_29494;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29470;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29471;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29474;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29480;
    @Shadow
    @Final
    @Nullable
    public class_284 field_42231;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29477;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29478;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29479;
    @Shadow
    @Final
    @Nullable
    public class_284 field_36373;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29472;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29481;
    @Shadow
    @Final
    @Nullable
    public class_284 field_29473;
    @Shadow
    @Final
    private Map<String, Object> field_29487;
    @Shadow
    @Final
    private List<Integer> field_29489;
    @Shadow
    @Final
    private List<String> field_29488;
    @Unique
    private String vsPath;
    @Unique
    private String fsName;
    @Unique
    private GraphicsPipeline pipeline;
    @Unique
    boolean doUniformUpdate = false;

    @Override
    public GraphicsPipeline getPipeline() {
        return this.pipeline;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void create(class_5912 resourceProvider, String name, class_293 format, CallbackInfo ci) {
        GraphicsPipeline pipeline;
        String configName = name;
        JsonObject config = ShaderLoadUtil.getJsonConfig("core", configName);
        if (config == null) {
            this.createLegacyShader(resourceProvider, format);
            return;
        }
        Pipeline.Builder builder = new Pipeline.Builder(format, configName);
        builder.setUniformSupplierGetter(info -> this.getUniformSupplier(info.name));
        builder.parseBindings(config);
        ShaderLoadUtil.loadShaders(builder, config, configName, "core");
        this.pipeline = pipeline = builder.createGraphicsPipeline();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ShaderInstance;getOrCreate(Lnet/minecraft/server/packs/resources/ResourceProvider;Lcom/mojang/blaze3d/shaders/Program$Type;Ljava/lang/String;)Lcom/mojang/blaze3d/shaders/Program;"))
    private class_281 loadNames(class_5912 resourceProvider, class_281.class_282 type, String name) {
        String path;
        if (this.field_29494.contains(String.valueOf(':'))) {
            class_2960 location = class_2960.method_12829((String)name);
            path = location.method_45136("shaders/core/%s".formatted(location.method_12832())).toString();
        } else {
            path = "shaders/core/%s".formatted(name);
        }
        switch (type) {
            case field_1530: {
                this.vsPath = path;
                break;
            }
            case field_1531: {
                this.fsName = path;
            }
        }
        return null;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/shaders/Uniform;glBindAttribLocation(IILjava/lang/CharSequence;)V"))
    private void bindAttr(int program, int index, CharSequence name) {
    }

    @Overwrite
    public void close() {
        if (this.pipeline != null) {
            this.pipeline.cleanUp();
        }
    }

    @Overwrite
    public void method_34586() {
        if (!this.doUniformUpdate) {
            return;
        }
        for (int j = 0; j < this.field_29489.size(); ++j) {
            String string = this.field_29488.get(j);
            if (this.field_29487.get(string) == null) continue;
            RenderSystem.activeTexture((int)(33984 + j));
            Object object = this.field_29487.get(string);
            int texId = -1;
            if (object instanceof class_276) {
                texId = ((class_276)object).method_30277();
            } else if (object instanceof class_1044) {
                texId = ((class_1044)object).method_4624();
            } else if (object instanceof Integer) {
                texId = (Integer)object;
            }
            if (texId == -1) continue;
            RenderSystem.bindTexture((int)texId);
            RenderSystem.setShaderTexture((int)j, (int)texId);
        }
        if (this.field_29470 != null) {
            this.field_29470.method_1250(RenderSystem.getModelViewMatrix());
        }
        if (this.field_29471 != null) {
            this.field_29471.method_1250(RenderSystem.getProjectionMatrix());
        }
        if (this.field_29474 != null) {
            this.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (this.field_42231 != null) {
            this.field_42231.method_1251(RenderSystem.getShaderGlintAlpha());
        }
        if (this.field_29477 != null) {
            this.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (this.field_29478 != null) {
            this.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (this.field_29479 != null) {
            this.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (this.field_36373 != null) {
            this.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
        }
        if (this.field_29472 != null) {
            this.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (this.field_29481 != null) {
            this.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (this.field_29473 != null) {
            class_1041 window = class_310.method_1551().method_22683();
            this.field_29473.method_1255((float)window.method_4489(), (float)window.method_4506());
        }
        if (this.field_29480 != null) {
            this.field_29480.method_1251(RenderSystem.getShaderLineWidth());
        }
    }

    @Overwrite
    public void method_34585() {
    }

    @Override
    public void setupUniformSuppliers(UBO ubo) {
        for (Uniform vUniform : ubo.getUniforms()) {
            ByteBuffer byteBuffer;
            class_284 uniform = this.field_29492.get(vUniform.getName());
            if (uniform == null) {
                Initializer.LOGGER.error(String.format("Error: field %s not present in uniform map", vUniform.getName()));
                int size = vUniform.getSize();
                byteBuffer = MemoryUtil.memAlloc((int)(size * 4));
            } else if (uniform.method_35662() <= 3) {
                byteBuffer = MemoryUtil.memByteBuffer((IntBuffer)uniform.method_35663());
            } else if (uniform.method_35662() <= 10) {
                byteBuffer = MemoryUtil.memByteBuffer((FloatBuffer)uniform.method_35664());
            } else {
                throw new RuntimeException("out of bounds value for uniform " + String.valueOf(uniform));
            }
            MappedBuffer mappedBuffer = MappedBuffer.createFromBuffer(byteBuffer);
            Supplier<MappedBuffer> supplier = () -> mappedBuffer;
            vUniform.setSupplier(supplier);
        }
    }

    @Override
    public Supplier<MappedBuffer> getUniformSupplier(String name) {
        ByteBuffer byteBuffer;
        class_284 uniform1 = this.field_29492.get(name);
        if (uniform1 == null) {
            Initializer.LOGGER.error(String.format("Error: field %s not present in uniform map", name));
            return null;
        }
        if (uniform1.method_35662() <= 3) {
            byteBuffer = MemoryUtil.memByteBuffer((IntBuffer)uniform1.method_35663());
        } else if (uniform1.method_35662() <= 10) {
            byteBuffer = MemoryUtil.memByteBuffer((FloatBuffer)uniform1.method_35664());
        } else {
            throw new RuntimeException("out of bounds value for uniform " + String.valueOf(uniform1));
        }
        MappedBuffer mappedBuffer = MappedBuffer.createFromBuffer(byteBuffer);
        Supplier<MappedBuffer> supplier = () -> mappedBuffer;
        return supplier;
    }

    @Override
    public void setDoUniformsUpdate() {
        this.doUniformUpdate = true;
    }

    @Override
    public void setPipeline(GraphicsPipeline graphicsPipeline) {
        this.pipeline = graphicsPipeline;
    }

    private void createLegacyShader(class_5912 resourceProvider, class_293 format) {
        try {
            String vertPath = this.vsPath + ".vsh";
            class_3298 resource = resourceProvider.getResourceOrThrow(class_2960.method_12829((String)vertPath));
            InputStream inputStream = resource.method_14482();
            String vshSrc = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            String fragPath = this.fsName + ".fsh";
            resource = resourceProvider.getResourceOrThrow(class_2960.method_12829((String)fragPath));
            inputStream = resource.method_14482();
            String fshSrc = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            GlslConverter converter = new GlslConverter();
            Pipeline.Builder builder = new Pipeline.Builder(format, this.field_29494);
            converter.process(vshSrc, fshSrc);
            UBO ubo = converter.createUBO();
            this.setupUniformSuppliers(ubo);
            builder.setUniforms(Collections.singletonList(ubo), converter.getSamplerList());
            builder.compileShaders(this.field_29494, converter.getVshConverted(), converter.getFshConverted());
            this.pipeline = builder.createGraphicsPipeline();
            this.doUniformUpdate = true;
        }
        catch (Exception e) {
            Initializer.LOGGER.error("Error on shader {} conversion/compilation", (Object)this.field_29494);
            e.printStackTrace();
        }
    }
}

