/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import net.vulkanmod.interfaces.ShaderMixed;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.VRenderSystem;
import net.vulkanmod.vulkan.memory.AutoIndexBuffer;
import net.vulkanmod.vulkan.memory.IndexBuffer;
import net.vulkanmod.vulkan.memory.MemoryType;
import net.vulkanmod.vulkan.memory.MemoryTypes;
import net.vulkanmod.vulkan.memory.VertexBuffer;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.shader.Pipeline;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class VBO {
    private final MemoryType memoryType;
    private VertexBuffer vertexBuffer;
    private IndexBuffer indexBuffer;
    private int indexCount;
    private int vertexCount;
    private class_293.class_5596 mode;
    private boolean autoIndexed = false;

    public VBO(class_291.class_8555 usage) {
        this.memoryType = usage == class_291.class_8555.field_44793 ? MemoryTypes.GPU_MEM : MemoryTypes.HOST_MEM;
    }

    public void upload(class_9801 meshData) {
        class_9801.class_4574 parameters = meshData.method_60822();
        this.indexCount = parameters.comp_751();
        this.vertexCount = parameters.comp_750();
        this.mode = parameters.comp_752();
        this.uploadVertexBuffer(parameters, meshData.method_60818());
        this.uploadIndexBuffer(meshData.method_60821());
        meshData.close();
    }

    private void uploadVertexBuffer(class_9801.class_4574 parameters, ByteBuffer data) {
        if (data != null) {
            if (this.vertexBuffer != null) {
                this.vertexBuffer.scheduleFree();
            }
            this.vertexBuffer = new VertexBuffer(data.remaining(), this.memoryType);
            this.vertexBuffer.copyToVertexBuffer(parameters.comp_749().method_1362(), parameters.comp_750(), data);
        }
    }

    public void uploadIndexBuffer(ByteBuffer data) {
        if (data == null) {
            AutoIndexBuffer autoIndexBuffer;
            switch (this.mode) {
                case field_27381: {
                    autoIndexBuffer = Renderer.getDrawer().getTriangleFanIndexBuffer();
                    this.indexCount = AutoIndexBuffer.DrawType.getTriangleStripIndexCount(this.vertexCount);
                    break;
                }
                case field_27380: 
                case field_27378: {
                    autoIndexBuffer = Renderer.getDrawer().getTriangleStripIndexBuffer();
                    this.indexCount = AutoIndexBuffer.DrawType.getTriangleStripIndexCount(this.vertexCount);
                    break;
                }
                case field_27382: {
                    autoIndexBuffer = Renderer.getDrawer().getQuadsIndexBuffer();
                    break;
                }
                case field_27377: {
                    autoIndexBuffer = Renderer.getDrawer().getLinesIndexBuffer();
                    break;
                }
                case field_29345: {
                    autoIndexBuffer = Renderer.getDrawer().getDebugLineStripIndexBuffer();
                    break;
                }
                case field_27379: 
                case field_29344: {
                    autoIndexBuffer = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected draw mode: %s".formatted(this.mode));
                }
            }
            if (this.indexBuffer != null && !this.autoIndexed) {
                this.indexBuffer.scheduleFree();
            }
            if (autoIndexBuffer != null) {
                autoIndexBuffer.checkCapacity(this.vertexCount);
                this.indexBuffer = autoIndexBuffer.getIndexBuffer();
            }
            this.autoIndexed = true;
        } else {
            if (this.indexBuffer != null) {
                this.indexBuffer.scheduleFree();
            }
            this.indexBuffer = new IndexBuffer(data.remaining(), MemoryTypes.GPU_MEM);
            this.indexBuffer.copyBuffer(data);
        }
    }

    public void drawWithShader(Matrix4f MV, Matrix4f P, class_5944 shader) {
        if (this.indexCount != 0) {
            RenderSystem.assertOnRenderThread();
            RenderSystem.setShader(() -> shader);
            this.drawWithShader(MV, P, ((ShaderMixed)shader).getPipeline());
        }
    }

    public void drawWithShader(Matrix4f MV, Matrix4f P, GraphicsPipeline pipeline) {
        if (this.indexCount != 0) {
            RenderSystem.assertOnRenderThread();
            VRenderSystem.applyMVP(MV, P);
            VRenderSystem.setPrimitiveTopologyGL(this.mode.field_27383);
            Renderer renderer = Renderer.getInstance();
            renderer.bindGraphicsPipeline(pipeline);
            VTextureSelector.bindShaderTextures(pipeline);
            renderer.uploadAndBindUBOs(pipeline);
            if (this.indexBuffer != null) {
                Renderer.getDrawer().drawIndexed(this.vertexBuffer, this.indexBuffer, this.indexCount);
            } else {
                Renderer.getDrawer().draw(this.vertexBuffer, this.vertexCount);
            }
            VRenderSystem.applyMVP(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix());
        }
    }

    public void draw() {
        if (this.indexCount != 0) {
            RenderSystem.assertOnRenderThread();
            Renderer renderer = Renderer.getInstance();
            Pipeline pipeline = renderer.getBoundPipeline();
            renderer.uploadAndBindUBOs(pipeline);
            Renderer.getDrawer().drawIndexed(this.vertexBuffer, this.indexBuffer, this.indexCount);
        }
    }

    public void close() {
        if (this.vertexCount <= 0) {
            return;
        }
        this.vertexBuffer.scheduleFree();
        this.vertexBuffer = null;
        if (!this.autoIndexed) {
            this.indexBuffer.scheduleFree();
            this.indexBuffer = null;
        }
        this.vertexCount = 0;
        this.indexCount = 0;
    }
}

