/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_4720;
import net.minecraft.class_638;
import net.vulkanmod.Initializer;
import net.vulkanmod.render.PipelineManager;
import net.vulkanmod.render.chunk.ChunkArea;
import net.vulkanmod.render.chunk.ChunkAreaManager;
import net.vulkanmod.render.chunk.ChunkStatusMap;
import net.vulkanmod.render.chunk.RenderSection;
import net.vulkanmod.render.chunk.SectionGrid;
import net.vulkanmod.render.chunk.buffer.DrawBuffers;
import net.vulkanmod.render.chunk.build.RenderRegionBuilder;
import net.vulkanmod.render.chunk.build.task.ChunkTask;
import net.vulkanmod.render.chunk.build.task.TaskDispatcher;
import net.vulkanmod.render.chunk.graph.SectionGraph;
import net.vulkanmod.render.chunk.util.StaticQueue;
import net.vulkanmod.render.profiling.BuildTimeProfiler;
import net.vulkanmod.render.profiling.Profiler;
import net.vulkanmod.render.vertex.TerrainRenderType;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.VRenderSystem;
import net.vulkanmod.vulkan.memory.Buffer;
import net.vulkanmod.vulkan.memory.IndexBuffer;
import net.vulkanmod.vulkan.memory.IndirectBuffer;
import net.vulkanmod.vulkan.memory.MemoryTypes;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class WorldRenderer {
    private static WorldRenderer INSTANCE;
    private final class_310 minecraft;
    private class_638 level;
    private int renderDistance;
    private final class_4599 renderBuffers;
    private class_243 cameraPos;
    private int lastCameraSectionX;
    private int lastCameraSectionY;
    private int lastCameraSectionZ;
    private float lastCameraX;
    private float lastCameraY;
    private float lastCameraZ;
    private float lastCamRotX;
    private float lastCamRotY;
    private SectionGrid sectionGrid;
    private SectionGraph sectionGraph;
    private boolean graphNeedsUpdate;
    private final Set<class_2586> globalBlockEntities = Sets.newHashSet();
    private final TaskDispatcher taskDispatcher;
    private double xTransparentOld;
    private double yTransparentOld;
    private double zTransparentOld;
    IndirectBuffer[] indirectBuffers;
    public RenderRegionBuilder renderRegionCache;
    private final List<Runnable> onAllChangedCallbacks = new ObjectArrayList();

    private WorldRenderer(class_4599 renderBuffers) {
        this.minecraft = class_310.method_1551();
        this.renderBuffers = renderBuffers;
        this.renderRegionCache = new RenderRegionBuilder();
        this.taskDispatcher = new TaskDispatcher();
        ChunkTask.setTaskDispatcher(this.taskDispatcher);
        this.allocateIndirectBuffers();
        TerrainRenderType.updateMapping();
        Renderer.getInstance().addOnResizeCallback(() -> {
            if (this.indirectBuffers.length != Renderer.getFramesNum()) {
                this.allocateIndirectBuffers();
            }
        });
    }

    private void allocateIndirectBuffers() {
        if (this.indirectBuffers != null) {
            Arrays.stream(this.indirectBuffers).forEach(Buffer::scheduleFree);
        }
        this.indirectBuffers = new IndirectBuffer[Renderer.getFramesNum()];
        for (int i = 0; i < this.indirectBuffers.length; ++i) {
            this.indirectBuffers[i] = new IndirectBuffer(1000000, MemoryTypes.HOST_MEM);
        }
    }

    public static WorldRenderer init(class_4599 renderBuffers) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new WorldRenderer(renderBuffers);
        return INSTANCE;
    }

    public static WorldRenderer getInstance() {
        return INSTANCE;
    }

    public static class_638 getLevel() {
        return WorldRenderer.INSTANCE.level;
    }

    public static class_243 getCameraPos() {
        return WorldRenderer.INSTANCE.cameraPos;
    }

    private void benchCallback() {
        BuildTimeProfiler.runBench(this.graphNeedsUpdate || !this.taskDispatcher.isIdle());
    }

    public void setupRenderer(class_4184 camera, class_4604 frustum, boolean isCapturedFrustum, boolean spectator) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.push("Setup_Renderer");
        this.benchCallback();
        this.cameraPos = camera.method_19326();
        if (this.minecraft.field_1690.method_38521() != this.renderDistance) {
            this.allChanged();
        }
        this.level.method_16107().method_15396("camera");
        float cameraX = (float)this.cameraPos.method_10216();
        float cameraY = (float)this.cameraPos.method_10214();
        float cameraZ = (float)this.cameraPos.method_10215();
        int sectionX = class_4076.method_32204((double)cameraX);
        int sectionY = class_4076.method_32204((double)cameraY);
        int sectionZ = class_4076.method_32204((double)cameraZ);
        profiler.push("reposition");
        if (this.lastCameraSectionX != sectionX || this.lastCameraSectionY != sectionY || this.lastCameraSectionZ != sectionZ) {
            this.lastCameraSectionX = sectionX;
            this.lastCameraSectionY = sectionY;
            this.lastCameraSectionZ = sectionZ;
            this.sectionGrid.repositionCamera(cameraX, cameraZ);
        }
        profiler.pop();
        double entityDistanceScaling = (Double)this.minecraft.field_1690.method_42517().method_41753();
        class_1297.method_5840((double)(class_3532.method_15350((double)((double)this.renderDistance / 8.0), (double)1.0, (double)2.5) * entityDistanceScaling));
        this.level.method_16107().method_15405("cull");
        this.minecraft.method_16011().method_15405("culling");
        this.minecraft.method_16011().method_15405("update");
        boolean cameraMoved = false;
        float d_xRot = Math.abs(camera.method_19329() - this.lastCamRotX);
        float d_yRot = Math.abs(camera.method_19330() - this.lastCamRotY);
        cameraMoved |= d_xRot > 2.0f || d_yRot > 2.0f;
        this.graphNeedsUpdate |= (cameraMoved |= cameraX != this.lastCameraX || cameraY != this.lastCameraY || cameraZ != this.lastCameraZ);
        if (!isCapturedFrustum && this.graphNeedsUpdate) {
            this.graphNeedsUpdate = false;
            this.lastCameraX = cameraX;
            this.lastCameraY = cameraY;
            this.lastCameraZ = cameraZ;
            this.lastCamRotX = camera.method_19329();
            this.lastCamRotY = camera.method_19330();
            this.sectionGraph.update(camera, frustum, spectator);
        }
        this.indirectBuffers[Renderer.getCurrentFrame()].reset();
        this.minecraft.method_16011().method_15407();
        profiler.pop();
    }

    public void uploadSections() {
        this.minecraft.method_16011().method_15396("upload");
        Profiler profiler = Profiler.getMainProfiler();
        profiler.push("Uploads");
        try {
            if (this.taskDispatcher.updateSections()) {
                this.graphNeedsUpdate = true;
            }
        }
        catch (Exception e) {
            Initializer.LOGGER.error(e.getMessage());
            this.allChanged();
        }
        profiler.pop();
        this.minecraft.method_16011().method_15407();
    }

    public boolean isSectionCompiled(class_2338 blockPos) {
        RenderSection renderSection = this.sectionGrid.getSectionAtBlockPos(blockPos);
        return renderSection != null && renderSection.isCompiled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allChanged() {
        if (this.level != null) {
            this.level.method_23784();
            this.renderRegionCache.clear();
            this.taskDispatcher.createThreads();
            this.graphNeedsUpdate = true;
            this.renderDistance = this.minecraft.field_1690.method_38521();
            if (this.sectionGrid != null) {
                this.sectionGrid.freeAllBuffers();
            }
            this.taskDispatcher.clearBatchQueue();
            Set<class_2586> set = this.globalBlockEntities;
            synchronized (set) {
                this.globalBlockEntities.clear();
            }
            this.sectionGrid = new SectionGrid((class_1937)this.level, this.renderDistance);
            this.sectionGraph = new SectionGraph((class_1937)this.level, this.sectionGrid, this.taskDispatcher);
            this.onAllChangedCallbacks.forEach(Runnable::run);
            class_1297 entity = this.minecraft.method_1560();
            if (entity != null) {
                this.sectionGrid.repositionCamera(entity.method_23317(), entity.method_23321());
            }
        }
    }

    public void setLevel(@Nullable class_638 level) {
        this.lastCameraX = Float.MIN_VALUE;
        this.lastCameraY = Float.MIN_VALUE;
        this.lastCameraZ = Float.MIN_VALUE;
        this.lastCameraSectionX = Integer.MIN_VALUE;
        this.lastCameraSectionY = Integer.MIN_VALUE;
        this.lastCameraSectionZ = Integer.MIN_VALUE;
        this.level = level;
        ChunkStatusMap.createInstance(this.renderDistance);
        if (level != null) {
            this.allChanged();
        } else {
            if (this.sectionGrid != null) {
                this.sectionGrid.freeAllBuffers();
                this.sectionGrid = null;
            }
            this.taskDispatcher.stopThreads();
            this.graphNeedsUpdate = true;
        }
    }

    public void addOnAllChangedCallback(Runnable runnable) {
        this.onAllChangedCallbacks.add(runnable);
    }

    public void clearOnAllChangedCallbacks() {
        this.onAllChangedCallbacks.clear();
    }

    public void renderSectionLayer(class_1921 renderType, double camX, double camY, double camZ, Matrix4f modelView, Matrix4f projection) {
        EnumSet<TerrainRenderType> allowedRenderTypes;
        TerrainRenderType terrainRenderType = TerrainRenderType.get(renderType);
        renderType.method_23516();
        this.sortTranslucentSections(camX, camY, camZ);
        this.minecraft.method_16011().method_15396("filterempty");
        this.minecraft.method_16011().method_15403(() -> "render_" + String.valueOf(renderType));
        boolean isTranslucent = terrainRenderType == TerrainRenderType.TRANSLUCENT;
        boolean indirectDraw = Initializer.CONFIG.indirectDraw;
        VRenderSystem.applyMVP(modelView, projection);
        VRenderSystem.setPrimitiveTopologyGL(4);
        Renderer renderer = Renderer.getInstance();
        GraphicsPipeline pipeline = PipelineManager.getTerrainShader(terrainRenderType);
        renderer.bindGraphicsPipeline(pipeline);
        VTextureSelector.bindShaderTextures(pipeline);
        IndexBuffer indexBuffer = Renderer.getDrawer().getQuadsIndexBuffer().getIndexBuffer();
        Renderer.getDrawer().bindIndexBuffer(Renderer.getCommandBuffer(), indexBuffer);
        int currentFrame = Renderer.getCurrentFrame();
        EnumSet<TerrainRenderType> enumSet = allowedRenderTypes = Initializer.CONFIG.uniqueOpaqueLayer ? TerrainRenderType.COMPACT_RENDER_TYPES : TerrainRenderType.SEMI_COMPACT_RENDER_TYPES;
        if (allowedRenderTypes.contains((Object)terrainRenderType)) {
            terrainRenderType.setCutoutUniform();
            Iterator<ChunkArea> iterator = this.sectionGraph.getChunkAreaQueue().iterator(isTranslucent);
            while (iterator.hasNext()) {
                ChunkArea chunkArea = iterator.next();
                StaticQueue<RenderSection> queue = chunkArea.sectionQueue;
                DrawBuffers drawBuffers = chunkArea.drawBuffers;
                renderer.uploadAndBindUBOs(pipeline);
                if (drawBuffers.getAreaBuffer(terrainRenderType) == null || queue.size() <= 0) continue;
                drawBuffers.bindBuffers(Renderer.getCommandBuffer(), pipeline, terrainRenderType, camX, camY, camZ);
                renderer.uploadAndBindUBOs(pipeline);
                if (indirectDraw) {
                    drawBuffers.buildDrawBatchesIndirect(this.cameraPos, this.indirectBuffers[currentFrame], queue, terrainRenderType);
                    continue;
                }
                drawBuffers.buildDrawBatchesDirect(this.cameraPos, queue, terrainRenderType);
            }
        }
        if (terrainRenderType == TerrainRenderType.CUTOUT || terrainRenderType == TerrainRenderType.TRIPWIRE) {
            this.indirectBuffers[currentFrame].submitUploads();
        }
        if (!indirectDraw) {
            VRenderSystem.setModelOffset(0.0f, 0.0f, 0.0f);
            renderer.pushConstants(pipeline);
        }
        this.minecraft.method_16011().method_15407();
        renderType.method_23518();
        VRenderSystem.applyMVP(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix());
    }

    private void sortTranslucentSections(double camX, double camY, double camZ) {
        this.minecraft.method_16011().method_15396("translucent_sort");
        double d0 = camX - this.xTransparentOld;
        double d1 = camY - this.yTransparentOld;
        double d2 = camZ - this.zTransparentOld;
        if (d0 * d0 + d1 * d1 + d2 * d2 > 2.0) {
            this.xTransparentOld = camX;
            this.yTransparentOld = camY;
            this.zTransparentOld = camZ;
            Iterator<RenderSection> iterator = this.sectionGraph.getSectionQueue().iterator(false);
            for (int j = 0; iterator.hasNext() && j < 15; ++j) {
                RenderSection section = iterator.next();
                section.resortTransparency(this.taskDispatcher);
            }
        }
        this.minecraft.method_16011().method_15407();
    }

    public void renderBlockEntities(class_4587 poseStack, double camX, double camY, double camZ, Long2ObjectMap<SortedSet<class_3191>> destructionProgress, float gameTime) {
        Profiler profiler = Profiler.getMainProfiler();
        profiler.pop();
        profiler.push("Block-entities");
        class_4597.class_4598 bufferSource = this.renderBuffers.method_23000();
        for (RenderSection renderSection : this.sectionGraph.getBlockEntitiesSections()) {
            List<class_2586> list = renderSection.getCompiledSection().getBlockEntities();
            if (list.isEmpty()) continue;
            for (class_2586 blockEntity : list) {
                int j1;
                class_2338 blockPos = blockEntity.method_11016();
                class_4597.class_4598 bufferSource1 = bufferSource;
                poseStack.method_22903();
                poseStack.method_22904((double)blockPos.method_10263() - camX, (double)blockPos.method_10264() - camY, (double)blockPos.method_10260() - camZ);
                SortedSet sortedset = (SortedSet)destructionProgress.get(blockPos.method_10063());
                if (sortedset != null && !sortedset.isEmpty() && (j1 = ((class_3191)sortedset.last()).method_13988()) >= 0) {
                    class_4587.class_4665 pose = poseStack.method_23760();
                    class_4583 vertexconsumer = new class_4583(this.renderBuffers.method_23001().getBuffer((class_1921)class_1088.field_21772.get(j1)), pose, 1.0f);
                    bufferSource1 = arg_0 -> WorldRenderer.lambda$renderBlockEntities$2((class_4597)bufferSource, (class_4588)vertexconsumer, arg_0);
                }
                this.minecraft.method_31975().method_3555(blockEntity, gameTime, poseStack, (class_4597)bufferSource1);
                poseStack.method_22909();
            }
        }
    }

    public void scheduleGraphUpdate() {
        this.graphNeedsUpdate = true;
    }

    public boolean graphNeedsUpdate() {
        return this.graphNeedsUpdate;
    }

    public int getVisibleSectionsCount() {
        return this.sectionGraph.getSectionQueue().size();
    }

    public void setSectionDirty(int x, int y, int z, boolean flag) {
        this.sectionGrid.setDirty(x, y, z, flag);
        this.renderRegionCache.remove(x, z);
    }

    public SectionGrid getSectionGrid() {
        return this.sectionGrid;
    }

    public ChunkAreaManager getChunkAreaManager() {
        return this.sectionGrid.chunkAreaManager;
    }

    public TaskDispatcher getTaskDispatcher() {
        return this.taskDispatcher;
    }

    public short getLastFrame() {
        return this.sectionGraph.getLastFrame();
    }

    public int getRenderDistance() {
        return this.renderDistance;
    }

    public String getChunkStatistics() {
        return this.sectionGraph.getStatistics();
    }

    public void cleanUp() {
        if (this.indirectBuffers != null) {
            Arrays.stream(this.indirectBuffers).forEach(Buffer::scheduleFree);
        }
    }

    private static /* synthetic */ class_4588 lambda$renderBlockEntities$2(class_4597 bufferSource, class_4588 vertexconsumer, class_1921 renderType) {
        class_4588 vertexConsumer2 = bufferSource.getBuffer(renderType);
        return renderType.method_23037() ? class_4720.method_24037((class_4588)vertexconsumer, (class_4588)vertexConsumer2) : vertexConsumer2;
    }
}

