/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.frapi.render;

import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.vulkanmod.Initializer;
import net.vulkanmod.render.chunk.build.frapi.material.RenderMaterialImpl;
import net.vulkanmod.render.chunk.build.frapi.mesh.MutableQuadViewImpl;
import net.vulkanmod.render.chunk.build.frapi.render.AbstractBlockRenderContext;
import net.vulkanmod.render.chunk.build.light.LightPipeline;
import net.vulkanmod.render.chunk.build.light.data.ArrayLightDataCache;
import net.vulkanmod.render.chunk.build.light.flat.FlatLightPipeline;
import net.vulkanmod.render.chunk.build.light.smooth.NewSmoothLightPipeline;
import net.vulkanmod.render.chunk.build.light.smooth.SmoothLightPipeline;

public class BlockRenderContext
extends AbstractBlockRenderContext {
    private class_4588 vertexConsumer;
    private final ArrayLightDataCache lightDataCache = new ArrayLightDataCache();

    public BlockRenderContext() {
        FlatLightPipeline flatLightPipeline = new FlatLightPipeline(this.lightDataCache);
        LightPipeline smoothLightPipeline = Initializer.CONFIG.ambientOcclusion == 2 ? new NewSmoothLightPipeline(this.lightDataCache) : new SmoothLightPipeline(this.lightDataCache);
        this.setupLightPipelines(flatLightPipeline, smoothLightPipeline);
    }

    public void render(class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrixStack, class_4588 buffer, boolean cull, class_5819 random, long seed, int overlay) {
        try {
            class_243 offset = state.method_26226((class_1922)blockView, pos);
            matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
            this.blockPos = pos;
            this.vertexConsumer = buffer;
            this.matrix = matrixStack.method_23760().method_23761();
            this.normalMatrix = matrixStack.method_23760().method_23762();
            this.overlay = overlay;
            this.random = random;
            this.seed = seed;
            this.lightDataCache.reset(blockView, pos);
            this.prepareForWorld(blockView, cull);
            this.prepareForBlock(state, pos, model.method_4708());
            model.emitBlockQuads(blockView, state, pos, this.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block model - Indigo Renderer");
            class_129 crashReportSection = crashReport.method_562("Block model being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)blockView, (class_2338)pos, (class_2680)state);
            throw new class_148(crashReport);
        }
        finally {
            this.vertexConsumer = null;
        }
    }

    @Override
    protected void endRenderQuad(MutableQuadViewImpl quad) {
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        TriState aoMode = mat.ambientOcclusion();
        boolean ao = this.useAO && (aoMode == TriState.TRUE || aoMode == TriState.DEFAULT && this.defaultAO);
        boolean emissive = mat.emissive();
        boolean vanillaShade = mat.shadeMode() == ShadeMode.VANILLA;
        LightPipeline lightPipeline = ao ? this.smoothLightPipeline : this.flatLightPipeline;
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, lightPipeline, emissive, vanillaShade);
        this.bufferQuad(quad, this.vertexConsumer);
    }
}

