/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.light.smooth;

import net.vulkanmod.render.chunk.util.SimpleDirection;

enum AoNeighborInfo {
    DOWN(new SimpleDirection[]{SimpleDirection.SOUTH, SimpleDirection.WEST, SimpleDirection.NORTH, SimpleDirection.EAST}, new int[]{4, 5, 6, 7, 0, 1, 2, 3}, 0.5f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = 1.0f - x;
            float v = z;
            1.calculateCornerWeights(u, v, out);
        }

        @Override
        public float getU(float x, float y, float z) {
            return 1.0f - x;
        }

        @Override
        public float getV(float x, float y, float z) {
            return z;
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return y;
        }
    }
    ,
    UP(new SimpleDirection[]{SimpleDirection.NORTH, SimpleDirection.WEST, SimpleDirection.SOUTH, SimpleDirection.EAST}, new int[]{2, 3, 0, 1, 6, 7, 4, 5}, 1.0f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = 1.0f - x;
            float v = 1.0f - z;
            2.calculateCornerWeights(u, v, out);
        }

        @Override
        public float getU(float x, float y, float z) {
            return 1.0f - x;
        }

        @Override
        public float getV(float x, float y, float z) {
            return 1.0f - z;
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return 1.0f - y;
        }
    }
    ,
    NORTH(new SimpleDirection[]{SimpleDirection.UP, SimpleDirection.EAST, SimpleDirection.DOWN, SimpleDirection.WEST}, new int[]{3, 2, 7, 6, 1, 0, 5, 4}, 0.8f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = x;
            float v = y;
            3.calculateCornerWeights(u, v, out);
        }

        @Override
        public float getU(float x, float y, float z) {
            return x;
        }

        @Override
        public float getV(float x, float y, float z) {
            return y;
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return z;
        }
    }
    ,
    SOUTH(new SimpleDirection[]{SimpleDirection.UP, SimpleDirection.WEST, SimpleDirection.DOWN, SimpleDirection.EAST}, new int[]{0, 1, 4, 5, 2, 3, 6, 7}, 0.8f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = 1.0f - x;
            float v = y;
            4.calculateCornerWeights(u, v, out);
        }

        @Override
        public float getU(float x, float y, float z) {
            return 1.0f - x;
        }

        @Override
        public float getV(float x, float y, float z) {
            return y;
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return 1.0f - z;
        }
    }
    ,
    WEST(new SimpleDirection[]{SimpleDirection.UP, SimpleDirection.NORTH, SimpleDirection.DOWN, SimpleDirection.SOUTH}, new int[]{1, 3, 5, 7, 0, 2, 4, 6}, 0.6f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = 1.0f - z;
            float v = y;
            5.calculateCornerWeights(u, v, out);
        }

        @Override
        public float getU(float x, float y, float z) {
            return 1.0f - z;
        }

        @Override
        public float getV(float x, float y, float z) {
            return y;
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return x;
        }
    }
    ,
    EAST(new SimpleDirection[]{SimpleDirection.UP, SimpleDirection.SOUTH, SimpleDirection.DOWN, SimpleDirection.NORTH}, new int[]{2, 0, 6, 4, 3, 1, 7, 5}, 0.6f){

        @Override
        public void calculateCornerWeights(float x, float y, float z, float[] out) {
            float u = z;
            float v = y;
            6.calculateCornerWeights(u, v, out);
        }

        @Override
        public float getU(float x, float y, float z) {
            return z;
        }

        @Override
        public float getV(float x, float y, float z) {
            return y;
        }

        @Override
        public float getDepth(float x, float y, float z) {
            return 1.0f - x;
        }
    };

    public final SimpleDirection[] faces;
    public final float strength;
    public final int[] inCornerBits = new int[8];
    public final int[] outCornerBits = new int[24];
    private static final AoNeighborInfo[] VALUES;

    private AoNeighborInfo(SimpleDirection[] directions, int[] indices, float strength) {
        this.faces = directions;
        this.strength = strength;
        AoNeighborInfo.copyInCornerBits(this.inCornerBits, indices);
        AoNeighborInfo.getOutCornerBits(this.outCornerBits, indices);
    }

    public abstract void calculateCornerWeights(float var1, float var2, float var3, float[] var4);

    public abstract float getU(float var1, float var2, float var3);

    public abstract float getV(float var1, float var2, float var3);

    public void copyLightValues(int[] lm0, float[] ao0, int[] lm1, float[] ao1) {
        lm1[0] = lm0[0];
        lm1[1] = lm0[1];
        lm1[2] = lm0[2];
        lm1[3] = lm0[3];
        ao1[0] = ao0[0];
        ao1[1] = ao0[1];
        ao1[2] = ao0[2];
        ao1[3] = ao0[3];
    }

    public abstract float getDepth(float var1, float var2, float var3);

    public static AoNeighborInfo get(SimpleDirection direction) {
        return VALUES[direction.get3DDataValue()];
    }

    public static void calculateCornerWeights(float u, float v, float[] out) {
        out[0] = u * v;
        out[1] = u * (1.0f - v);
        out[2] = (1.0f - u) * (1.0f - v);
        out[3] = (1.0f - u) * v;
    }

    private static void copyInCornerBits(int[] cornersBits, int[] idxs) {
        cornersBits[0] = idxs[0];
        cornersBits[1] = idxs[1];
        cornersBits[2] = idxs[2];
        cornersBits[3] = idxs[3];
        cornersBits[4] = idxs[4];
        cornersBits[5] = idxs[5];
        cornersBits[6] = idxs[6];
        cornersBits[7] = idxs[7];
    }

    private static void getOutCornerBits(int[] cornersBits, int[] idxs) {
        cornersBits[0] = idxs[0];
        cornersBits[1] = idxs[3];
        cornersBits[2] = idxs[1];
        cornersBits[3] = idxs[1];
        cornersBits[4] = idxs[2];
        cornersBits[5] = idxs[3];
        cornersBits[6] = idxs[3];
        cornersBits[7] = idxs[0];
        cornersBits[8] = idxs[2];
        cornersBits[9] = idxs[2];
        cornersBits[10] = idxs[1];
        cornersBits[11] = idxs[0];
        cornersBits[12] = idxs[4];
        cornersBits[13] = idxs[7];
        cornersBits[14] = idxs[5];
        cornersBits[15] = idxs[5];
        cornersBits[16] = idxs[6];
        cornersBits[17] = idxs[7];
        cornersBits[18] = idxs[7];
        cornersBits[19] = idxs[4];
        cornersBits[20] = idxs[6];
        cornersBits[21] = idxs[6];
        cornersBits[22] = idxs[5];
        cornersBits[23] = idxs[4];
    }

    static {
        VALUES = AoNeighborInfo.values();
    }
}

