/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.shader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.vulkanmod.vulkan.shader.Pipeline;
import net.vulkanmod.vulkan.shader.SPIRVUtils;
import org.apache.commons.io.IOUtils;

public abstract class ShaderLoadUtil {
    private static final String RESOURCES_PATH = SPIRVUtils.class.getResource("/assets/vulkanmod").toExternalForm();

    public static void loadShaders(Pipeline.Builder pipelineBuilder, JsonObject config, String configName, String path) {
        String vertexShader = config.has("vertex") ? config.get("vertex").getAsString() : configName;
        String fragmentShader = config.has("fragment") ? config.get("fragment").getAsString() : configName;
        vertexShader = ShaderLoadUtil.removeNameSpace(vertexShader);
        fragmentShader = ShaderLoadUtil.removeNameSpace(fragmentShader);
        vertexShader = ShaderLoadUtil.getFileName(vertexShader);
        fragmentShader = ShaderLoadUtil.getFileName(fragmentShader);
        ShaderLoadUtil.loadShader(pipelineBuilder, configName, path, vertexShader, SPIRVUtils.ShaderKind.VERTEX_SHADER);
        ShaderLoadUtil.loadShader(pipelineBuilder, configName, path, fragmentShader, SPIRVUtils.ShaderKind.FRAGMENT_SHADER);
    }

    public static void loadShader(Pipeline.Builder pipelineBuilder, String configName, String path, SPIRVUtils.ShaderKind type) {
        String[] splitPath = ShaderLoadUtil.splitPath(path);
        String shaderName = splitPath[1];
        String subPath = splitPath[0];
        ShaderLoadUtil.loadShader(pipelineBuilder, configName, subPath, shaderName, type);
    }

    public static void loadShader(Pipeline.Builder pipelineBuilder, String configName, String path, String shaderName, SPIRVUtils.ShaderKind type) {
        String basePath = "%s/shaders/%s".formatted(RESOURCES_PATH, path);
        String source = ShaderLoadUtil.getShaderSource(basePath, configName, shaderName, type);
        SPIRVUtils.SPIRV spirv = SPIRVUtils.compileShader(shaderName, source, type);
        switch (type) {
            case VERTEX_SHADER: {
                pipelineBuilder.setVertShaderSPIRV(spirv);
                break;
            }
            case FRAGMENT_SHADER: {
                pipelineBuilder.setFragShaderSPIRV(spirv);
            }
        }
    }

    public static String getConfigFilePath(String path, String rendertype) {
        Path filePath;
        String basePath = "%s/shaders/%s".formatted(RESOURCES_PATH, path);
        String configPath = "%s/%s/%s.json".formatted(basePath, rendertype, rendertype);
        try {
            filePath = FileSystems.getDefault().getPath(configPath, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                configPath = "%s/%s.json".formatted(basePath, rendertype);
                filePath = FileSystems.getDefault().getPath(configPath, new String[0]);
            }
            if (!Files.exists(filePath, new LinkOption[0])) {
                return null;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return filePath.toString();
    }

    public static JsonObject getJsonConfig(String path, String rendertype) {
        if (rendertype.contains(String.valueOf(':'))) {
            return null;
        }
        String basePath = "%s/shaders/%s".formatted(RESOURCES_PATH, path);
        String configPath = "%s/%s/%s.json".formatted(basePath, rendertype, rendertype);
        try {
            InputStream stream = ShaderLoadUtil.getInputStream(configPath);
            if (stream == null) {
                configPath = "%s/%s.json".formatted(basePath, rendertype);
                stream = ShaderLoadUtil.getInputStream(configPath);
            }
            if (stream == null) {
                return null;
            }
            JsonElement jsonElement = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(stream)));
            stream.close();
            return (JsonObject)jsonElement;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getShaderSource(String basePath, String rendertype, String shaderName, SPIRVUtils.ShaderKind type) {
        String shaderExtension = switch (type) {
            case SPIRVUtils.ShaderKind.VERTEX_SHADER -> ".vsh";
            case SPIRVUtils.ShaderKind.FRAGMENT_SHADER -> ".fsh";
            default -> throw new UnsupportedOperationException("shader type %s unsupported");
        };
        String shaderPath = "/%s/%s".formatted(rendertype, rendertype);
        String shaderFile = "%s%s%s".formatted(basePath, shaderPath, shaderExtension);
        try {
            InputStream stream = ShaderLoadUtil.getInputStream(shaderFile);
            if (stream == null) {
                shaderPath = "/%s/%s".formatted(rendertype, shaderName);
                shaderFile = "%s%s%s".formatted(basePath, shaderPath, shaderExtension);
                stream = ShaderLoadUtil.getInputStream(shaderFile);
            }
            if (stream == null) {
                shaderPath = "/%s/%s".formatted(shaderName, shaderName);
                shaderFile = "%s%s%s".formatted(basePath, shaderPath, shaderExtension);
                stream = ShaderLoadUtil.getInputStream(shaderFile);
            }
            if (stream == null) {
                return null;
            }
            String source = IOUtils.toString((Reader)new BufferedReader(new InputStreamReader(stream)));
            stream.close();
            return source;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFileName(String path) {
        int idx = path.lastIndexOf(47);
        return idx > -1 ? path.substring(idx + 1) : path;
    }

    public static String removeNameSpace(String path) {
        int idx = path.indexOf(58);
        return idx > -1 ? path.substring(idx + 1) : path;
    }

    public static String[] splitPath(String path) {
        int idx = path.lastIndexOf(47);
        return new String[]{path.substring(0, idx), path.substring(idx + 1)};
    }

    public static InputStream getInputStream(String path) {
        try {
            Path path1 = Paths.get(new URI(path));
            if (!Files.exists(path1, new LinkOption[0])) {
                return null;
            }
            return Files.newInputStream(path1, new OpenOption[0]);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

