/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.memory;

import java.nio.ByteBuffer;
import net.vulkanmod.render.chunk.buffer.UploadManager;
import net.vulkanmod.render.chunk.util.Util;
import net.vulkanmod.render.texture.ImageUploadHelper;
import net.vulkanmod.vulkan.Synchronization;
import net.vulkanmod.vulkan.memory.Buffer;
import net.vulkanmod.vulkan.memory.MemoryTypes;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libc.LibCString;

public class StagingBuffer
extends Buffer {
    private static final long DEFAULT_SIZE = 0x4000000L;

    public StagingBuffer() {
        this(0x4000000L);
    }

    public StagingBuffer(long size) {
        super(1, MemoryTypes.HOST_MEM);
        this.usedBytes = 0L;
        this.offset = 0L;
        this.createBuffer(size);
    }

    public void copyBuffer(int size, ByteBuffer byteBuffer) {
        if ((long)size > this.bufferSize) {
            throw new IllegalArgumentException("Upload size is greater than staging buffer size.");
        }
        if ((long)size > this.bufferSize - this.usedBytes) {
            this.submitUploads();
        }
        LibCString.nmemcpy((long)(this.dataPtr + this.usedBytes), (long)MemoryUtil.memAddress((ByteBuffer)byteBuffer), (long)size);
        this.offset = this.usedBytes;
        this.usedBytes += (long)size;
    }

    public void align(int alignment) {
        long alignedOffset = Util.align(this.usedBytes, alignment);
        if (alignedOffset > this.bufferSize) {
            this.submitUploads();
            alignedOffset = 0L;
        }
        this.usedBytes = alignedOffset;
    }

    private void submitUploads() {
        UploadManager.INSTANCE.submitUploads();
        ImageUploadHelper.INSTANCE.submitCommands();
        Synchronization.INSTANCE.waitFences();
        this.reset();
    }
}

