/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.texture;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import net.minecraft.class_1011;
import net.vulkanmod.render.texture.ImageUploadHelper;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.Vulkan;
import net.vulkanmod.vulkan.memory.MemoryManager;
import net.vulkanmod.vulkan.memory.StagingBuffer;
import net.vulkanmod.vulkan.queue.CommandPool;
import net.vulkanmod.vulkan.texture.ImageUtil;
import net.vulkanmod.vulkan.texture.SamplerManager;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkImageMemoryBarrier;
import org.lwjgl.vulkan.VkImageViewCreateInfo;

public class VulkanImage {
    public static int DefaultFormat = 37;
    private static final VkDevice DEVICE = Vulkan.getVkDevice();
    public final int format;
    public final int aspect;
    public final int mipLevels;
    public final int width;
    public final int height;
    public final int formatSize;
    public final int usage;
    public final int size;
    private long id;
    private long allocation;
    private long mainImageView;
    private long[] levelImageViews;
    private long sampler;
    private int currentLayout;

    public VulkanImage(long id, int format, int mipLevels, int width, int height, int formatSize, int usage, long imageView) {
        this.id = id;
        this.mainImageView = imageView;
        this.mipLevels = mipLevels;
        this.width = width;
        this.height = height;
        this.formatSize = formatSize;
        this.format = format;
        this.usage = usage;
        this.aspect = VulkanImage.getAspect(this.format);
        this.size = width * height * formatSize;
        this.sampler = SamplerManager.getTextureSampler((byte)this.mipLevels, (byte)0);
    }

    private VulkanImage(Builder builder) {
        this.mipLevels = builder.mipLevels;
        this.width = builder.width;
        this.height = builder.height;
        this.formatSize = builder.formatSize;
        this.format = builder.format;
        this.usage = builder.usage;
        this.aspect = VulkanImage.getAspect(this.format);
        this.size = this.width * this.height * this.formatSize;
    }

    public static VulkanImage createTextureImage(Builder builder) {
        VulkanImage image = new VulkanImage(builder);
        image.createImage();
        image.mainImageView = VulkanImage.createImageView(image.id, builder.format, image.aspect, builder.mipLevels);
        image.sampler = SamplerManager.getTextureSampler(builder.mipLevels, builder.samplerFlags);
        if (builder.levelViews) {
            image.levelImageViews = new long[builder.mipLevels];
            for (int i = 0; i < builder.mipLevels; ++i) {
                image.levelImageViews[i] = VulkanImage.createImageView(image.id, image.format, image.aspect, i, 1);
            }
        }
        return image;
    }

    public static VulkanImage createDepthImage(int format, int width, int height, int usage, boolean blur, boolean clamp) {
        VulkanImage image = VulkanImage.builder(width, height).setFormat(format).setUsage(usage).setLinearFiltering(blur).setClamp(clamp).createVulkanImage();
        return image;
    }

    public static VulkanImage createWhiteTexture() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int i = -1;
            ByteBuffer buffer = stack.malloc(4);
            buffer.putInt(0, i);
            VulkanImage image = VulkanImage.builder(1, 1).setFormat(DefaultFormat).setUsage(6).setLinearFiltering(false).setClamp(false).createVulkanImage();
            image.uploadSubTextureAsync(0, image.width, image.height, 0, 0, 0, 0, 0, buffer);
            VulkanImage vulkanImage = image;
            return vulkanImage;
        }
    }

    private void createImage() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer pTextureImage = stack.mallocLong(1);
            PointerBuffer pAllocation = stack.pointers(0L);
            MemoryManager.getInstance().createImage(this.width, this.height, this.mipLevels, this.format, 0, this.usage, 1, pTextureImage, pAllocation);
            this.id = pTextureImage.get(0);
            this.allocation = pAllocation.get(0);
            MemoryManager.addImage(this);
        }
    }

    public static int getAspect(int format) {
        return switch (format) {
            case 129, 130 -> 6;
            case 124, 125, 126 -> 2;
            default -> 1;
        };
    }

    public static boolean isDepthFormat(int format) {
        return switch (format) {
            case 124, 125, 126, 129, 130 -> true;
            default -> false;
        };
    }

    public static long createImageView(long image, int format, int aspectFlags, int mipLevels) {
        return VulkanImage.createImageView(image, format, aspectFlags, 0, mipLevels);
    }

    public static long createImageView(long image, int format, int aspectFlags, int baseMipLevel, int mipLevels) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkImageViewCreateInfo viewInfo = VkImageViewCreateInfo.calloc((MemoryStack)stack);
            viewInfo.sType(15);
            viewInfo.image(image);
            viewInfo.viewType(1);
            viewInfo.format(format);
            viewInfo.subresourceRange().aspectMask(aspectFlags);
            viewInfo.subresourceRange().baseMipLevel(baseMipLevel);
            viewInfo.subresourceRange().levelCount(mipLevels);
            viewInfo.subresourceRange().baseArrayLayer(0);
            viewInfo.subresourceRange().layerCount(1);
            LongBuffer pImageView = stack.mallocLong(1);
            if (VK10.vkCreateImageView((VkDevice)DEVICE, (VkImageViewCreateInfo)viewInfo, null, (LongBuffer)pImageView) != 0) {
                throw new RuntimeException("Failed to create texture image view");
            }
            long l = pImageView.get(0);
            return l;
        }
    }

    public void uploadSubTextureAsync(int mipLevel, int width, int height, int xOffset, int yOffset, int unpackSkipRows, int unpackSkipPixels, int unpackRowLength, ByteBuffer buffer) {
        StagingBuffer stagingBuffer;
        long uploadSize = buffer.limit();
        if (uploadSize > (stagingBuffer = Vulkan.getStagingBuffer()).getBufferSize()) {
            stagingBuffer = new StagingBuffer(uploadSize);
            stagingBuffer.scheduleFree();
        }
        stagingBuffer.align(this.formatSize);
        stagingBuffer.copyBuffer((int)uploadSize, buffer);
        long bufferId = stagingBuffer.getId();
        VkCommandBuffer commandBuffer = ImageUploadHelper.INSTANCE.getOrStartCommandBuffer().getHandle();
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.transferDstLayout(stack, commandBuffer);
            int srcOffset = (int)(stagingBuffer.getOffset() + (long)((unpackRowLength * unpackSkipRows + unpackSkipPixels) * this.formatSize));
            ImageUtil.copyBufferToImageCmd(stack, commandBuffer, bufferId, this.id, mipLevel, width, height, xOffset, yOffset, srcOffset, unpackRowLength, height);
        }
    }

    private void transferDstLayout(MemoryStack stack, VkCommandBuffer commandBuffer) {
        this.transitionImageLayout(stack, commandBuffer, 7);
    }

    public void readOnlyLayout() {
        if (this.currentLayout == 5) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (Renderer.getInstance().getBoundRenderPass() != null) {
                CommandPool.CommandBuffer commandBuffer = ImageUploadHelper.INSTANCE.getOrStartCommandBuffer();
                VkCommandBuffer vkCommandBuffer = commandBuffer.getHandle();
                this.readOnlyLayout(stack, vkCommandBuffer);
            } else {
                this.readOnlyLayout(stack, Renderer.getCommandBuffer());
            }
        }
    }

    public void readOnlyLayout(MemoryStack stack, VkCommandBuffer commandBuffer) {
        this.transitionImageLayout(stack, commandBuffer, 5);
    }

    public void updateTextureSampler(boolean blur, boolean clamp, boolean mipmaps) {
        byte flags = blur ? (byte)1 : 0;
        flags = (byte)(flags | (clamp ? 2 : 0));
        flags = (byte)(flags | (byte)(mipmaps ? 12 : 0));
        this.updateTextureSampler(flags);
    }

    public void updateTextureSampler(byte flags) {
        this.updateTextureSampler(this.mipLevels - 1, flags);
    }

    public void updateTextureSampler(int maxLod, byte flags) {
        this.sampler = SamplerManager.getTextureSampler((byte)maxLod, flags);
    }

    public void transitionImageLayout(MemoryStack stack, VkCommandBuffer commandBuffer, int newLayout) {
        VulkanImage.transitionImageLayout(stack, commandBuffer, this, newLayout);
    }

    public static void transitionImageLayout(MemoryStack stack, VkCommandBuffer commandBuffer, VulkanImage image, int newLayout) {
        int srcAccessMask;
        if (image.currentLayout == newLayout) {
            return;
        }
        int dstAccessMask = 0;
        VulkanImage.transitionLayout(stack, commandBuffer, image, image.currentLayout, newLayout, switch (image.currentLayout) {
            case 0, 1000001002 -> {
                srcAccessMask = 0;
                yield 8192;
            }
            case 7 -> {
                srcAccessMask = 4096;
                yield 4096;
            }
            case 6 -> {
                srcAccessMask = 2048;
                yield 4096;
            }
            case 5 -> {
                srcAccessMask = 32;
                yield 128;
            }
            case 2 -> {
                srcAccessMask = 256;
                yield 1024;
            }
            case 3 -> {
                srcAccessMask = 1536;
                yield 512;
            }
            default -> throw new RuntimeException("Unexpected value:" + image.currentLayout);
        }, srcAccessMask, switch (newLayout) {
            case 7 -> {
                dstAccessMask = 4096;
                yield 4096;
            }
            case 6 -> {
                dstAccessMask = 2048;
                yield 4096;
            }
            case 5 -> {
                dstAccessMask = 32;
                yield 128;
            }
            case 2 -> {
                dstAccessMask = 384;
                yield 1024;
            }
            case 3 -> {
                dstAccessMask = 1536;
                yield 256;
            }
            case 1000001002 -> 8192;
            default -> throw new RuntimeException("Unexpected value:" + newLayout);
        }, dstAccessMask);
    }

    public static void transitionLayout(MemoryStack stack, VkCommandBuffer commandBuffer, VulkanImage image, int oldLayout, int newLayout, int sourceStage, int srcAccessMask, int destinationStage, int dstAccessMask) {
        VulkanImage.transitionLayout(stack, commandBuffer, image, 0, oldLayout, newLayout, sourceStage, srcAccessMask, destinationStage, dstAccessMask);
    }

    public static void transitionLayout(MemoryStack stack, VkCommandBuffer commandBuffer, VulkanImage image, int baseLevel, int oldLayout, int newLayout, int sourceStage, int srcAccessMask, int destinationStage, int dstAccessMask) {
        VkImageMemoryBarrier.Buffer barrier = VkImageMemoryBarrier.calloc((int)1, (MemoryStack)stack);
        barrier.sType(45);
        barrier.oldLayout(image.currentLayout);
        barrier.newLayout(newLayout);
        barrier.srcQueueFamilyIndex(-1);
        barrier.dstQueueFamilyIndex(-1);
        barrier.image(image.getId());
        barrier.subresourceRange().baseMipLevel(baseLevel);
        barrier.subresourceRange().levelCount(-1);
        barrier.subresourceRange().baseArrayLayer(0);
        barrier.subresourceRange().layerCount(-1);
        barrier.subresourceRange().aspectMask(image.aspect);
        barrier.srcAccessMask(srcAccessMask);
        barrier.dstAccessMask(dstAccessMask);
        VK10.vkCmdPipelineBarrier((VkCommandBuffer)commandBuffer, (int)sourceStage, (int)destinationStage, (int)0, null, null, (VkImageMemoryBarrier.Buffer)barrier);
        image.currentLayout = newLayout;
    }

    private static boolean hasStencilComponent(int format) {
        return format == 130 || format == 129;
    }

    public void free() {
        MemoryManager.getInstance().addToFreeable(this);
    }

    public void doFree() {
        if (this.id == 0L) {
            return;
        }
        MemoryManager.freeImage(this.id, this.allocation);
        VK10.vkDestroyImageView((VkDevice)Vulkan.getVkDevice(), (long)this.mainImageView, null);
        if (this.levelImageViews != null) {
            Arrays.stream(this.levelImageViews).forEach(imageView -> VK10.vkDestroyImageView((VkDevice)Vulkan.getVkDevice(), (long)this.mainImageView, null));
        }
        this.id = 0L;
    }

    public int getCurrentLayout() {
        return this.currentLayout;
    }

    public void setCurrentLayout(int currentLayout) {
        this.currentLayout = currentLayout;
    }

    public long getId() {
        return this.id;
    }

    public long getAllocation() {
        return this.allocation;
    }

    public long getImageView() {
        return this.mainImageView;
    }

    public long getLevelImageView(int i) {
        return this.levelImageViews[i];
    }

    public long[] getLevelImageViews() {
        return this.levelImageViews;
    }

    public long getSampler() {
        return this.sampler;
    }

    public static Builder builder(int width, int height) {
        return new Builder(width, height);
    }

    public static class Builder {
        final int width;
        final int height;
        int format = DefaultFormat;
        int formatSize;
        byte mipLevels = 1;
        int usage = 7;
        byte samplerFlags = 0;
        boolean levelViews = false;

        public Builder(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Builder setFormat(int format) {
            this.format = format;
            return this;
        }

        public Builder setFormat(class_1011.class_1013 format) {
            this.format = Builder.convertFormat(format);
            return this;
        }

        public Builder setMipLevels(int n) {
            this.mipLevels = (byte)n;
            if (n > 1) {
                this.samplerFlags = (byte)(this.samplerFlags | 0xC);
            }
            return this;
        }

        public Builder setUsage(int usage) {
            this.usage = usage;
            return this;
        }

        public Builder addUsage(int usage) {
            this.usage |= usage;
            return this;
        }

        public Builder setLinearFiltering(boolean b) {
            this.samplerFlags = (byte)(this.samplerFlags | (b ? (byte)1 : 0));
            return this;
        }

        public Builder setClamp(boolean b) {
            this.samplerFlags = (byte)(this.samplerFlags | (b ? 2 : 0));
            return this;
        }

        public Builder setSamplerReductionModeMin() {
            this.samplerFlags = (byte)17;
            return this;
        }

        public Builder setLevelViews(boolean b) {
            this.levelViews = b;
            return this;
        }

        public VulkanImage createVulkanImage() {
            this.formatSize = Builder.formatSize(this.format);
            return VulkanImage.createTextureImage(this);
        }

        private static int convertFormat(class_1011.class_1013 format) {
            return switch (format) {
                case class_1011.class_1013.field_5012 -> 37;
                case class_1011.class_1013.field_33619 -> 9;
                default -> throw new IllegalArgumentException(String.format("Unxepcted format: %s", format));
            };
        }

        private static int formatSize(int format) {
            return switch (format) {
                case 37, 41, 42, 43, 126, 129 -> 4;
                case 9 -> 1;
                default -> throw new IllegalArgumentException(String.format("Unxepcted format: %s", format));
            };
        }
    }
}

