/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.render.target;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import net.vulkanmod.gl.GlFramebuffer;
import net.vulkanmod.gl.GlTexture;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.framebuffer.Framebuffer;
import net.vulkanmod.vulkan.texture.VTextureSelector;
import net.vulkanmod.vulkan.util.DrawUtil;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_276.class})
public abstract class RenderTargetMixin {
    @Shadow
    public int field_1480;
    @Shadow
    public int field_1477;
    @Shadow
    public int field_1482;
    @Shadow
    public int field_1481;
    @Shadow
    protected int field_1474;
    @Shadow
    protected int field_1475;
    @Shadow
    public int field_1476;
    @Shadow
    @Final
    private float[] field_1479;
    @Shadow
    @Final
    public boolean field_1478;
    boolean needClear = false;
    boolean bound = false;

    @Overwrite
    public void method_1230() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!Renderer.isRecording()) {
            return;
        }
        GlFramebuffer glFramebuffer = GlFramebuffer.getFramebuffer(this.field_1476);
        if (!this.bound || GlFramebuffer.getBoundFramebuffer() != glFramebuffer) {
            this.needClear = true;
            return;
        }
        GlStateManager._clearColor((float)this.field_1479[0], (float)this.field_1479[1], (float)this.field_1479[2], (float)this.field_1479[3]);
        int i = 16384;
        if (this.field_1478) {
            GlStateManager._clearDepth((double)1.0);
            i |= 0x100;
        }
        GlStateManager._clear((int)i);
        this.needClear = false;
    }

    @Overwrite
    public void method_35610() {
        RenderSystem.assertOnRenderThread();
        this.applyClear();
        GlTexture.bindTexture(this.field_1475);
        try (MemoryStack stack = MemoryStack.stackPush();){
            GlTexture.getBoundTexture().getVulkanImage().readOnlyLayout(stack, Renderer.getCommandBuffer());
        }
    }

    @Overwrite
    public void method_1242() {
        RenderSystem.assertOnRenderThreadOrInit();
        GlTexture.bindTexture(0);
    }

    @Overwrite
    public void method_1235(boolean bl) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlFramebuffer.bindFramebuffer(36160, this.field_1476);
        if (bl) {
            GlStateManager._viewport((int)0, (int)0, (int)this.field_1480, (int)this.field_1477);
        }
        this.bound = true;
        if (this.needClear) {
            this.method_1230();
        }
    }

    @Overwrite
    public void method_1240() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                GlStateManager._glBindFramebuffer((int)36160, (int)0);
                this.bound = false;
            });
        } else {
            GlStateManager._glBindFramebuffer((int)36160, (int)0);
            this.bound = false;
        }
    }

    @Inject(method={"blitToScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void blitToScreen(int width, int height, CallbackInfo ci) {
        if (!this.needClear) {
            Framebuffer framebuffer = GlFramebuffer.getFramebuffer(this.field_1476).getFramebuffer();
            VTextureSelector.bindTexture(0, framebuffer.getColorAttachment());
            DrawUtil.blitToScreen();
        }
        ci.cancel();
    }

    @Overwrite
    public void method_1233(int i, int j) {
        RenderSystem.assertOnRenderThread();
        if (this.needClear) {
            return;
        }
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._viewport((int)0, (int)0, (int)i, (int)j);
        class_5944 compiledShaderProgram = Objects.requireNonNull(RenderSystem.setShader((class_10156)class_10142.field_53868), "Blit shader not loaded");
        int prevTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShaderTexture((int)0, (int)this.field_1475);
        class_287 bufferBuilder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_29336);
        bufferBuilder.method_22912(0.0f, 0.0f, 0.0f);
        bufferBuilder.method_22912(1.0f, 0.0f, 0.0f);
        bufferBuilder.method_22912(1.0f, 1.0f, 0.0f);
        bufferBuilder.method_22912(0.0f, 1.0f, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.setShaderTexture((int)0, (int)prevTexture);
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    @Inject(method={"getColorTextureId"}, at={@At(value="HEAD")})
    private void injClear(CallbackInfoReturnable<Integer> cir) {
        this.applyClear();
    }

    @Unique
    private void applyClear() {
        if (this.needClear) {
            GlFramebuffer currentFramebuffer = GlFramebuffer.getBoundFramebuffer();
            this.method_1235(false);
            if (currentFramebuffer != null) {
                GlFramebuffer.beginRendering(currentFramebuffer);
            }
        }
    }
}

