/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build.color;

public abstract class BoxBlur {
    public static void blur(int[] buffer, int[] temp, int width, int filterRadius) {
        BoxBlur.horizontalBlur(buffer, temp, 0, width, filterRadius);
        BoxBlur.horizontalBlur(temp, buffer, filterRadius, width, filterRadius);
    }

    public static void horizontalBlur(int[] src, int[] dst, int y0, int width, int filterRadius) {
        int div = filterRadius * 2 + 1;
        int x0 = filterRadius;
        int totalWidth = filterRadius * 2 + width;
        for (int y = y0; y < totalWidth; ++y) {
            int color;
            int x;
            int r = 0;
            int g = 0;
            int b = 0;
            for (x = 0; x < x0 + 1 + filterRadius; ++x) {
                color = src[BoxBlur.getIdx(x, y, totalWidth)];
                r += BoxBlur.unpackR(color);
                g += BoxBlur.unpackG(color);
                b += BoxBlur.unpackB(color);
            }
            dst[BoxBlur.getIdx((int)y, (int)x0, (int)totalWidth)] = BoxBlur.packColor(r, g, b, div);
            for (x = x0 + 1; x < x0 + width; ++x) {
                color = src[BoxBlur.getIdx(x - filterRadius - 1, y, totalWidth)];
                r -= BoxBlur.unpackR(color);
                g -= BoxBlur.unpackG(color);
                b -= BoxBlur.unpackB(color);
                color = src[BoxBlur.getIdx(x + filterRadius, y, totalWidth)];
                dst[BoxBlur.getIdx((int)y, (int)x, (int)totalWidth)] = BoxBlur.packColor(r += BoxBlur.unpackR(color), g += BoxBlur.unpackG(color), b += BoxBlur.unpackB(color), div);
            }
        }
    }

    public static int getIdx(int x, int z, int width) {
        return x + z * width;
    }

    public static int unpackR(int color) {
        return color >> 16 & 0xFF;
    }

    public static int unpackG(int color) {
        return color >> 8 & 0xFF;
    }

    public static int unpackB(int color) {
        return color & 0xFF;
    }

    public static int packColor(int r, int g, int b, int div) {
        return 0xFF000000 | (r / div & 0xFF) << 16 | (g / div & 0xFF) << 8 | b / div & 0xFF;
    }
}

