/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.vertex;

import java.nio.ByteBuffer;
import net.minecraft.class_4588;
import net.vulkanmod.Initializer;
import net.vulkanmod.render.vertex.VertexBuilder;
import net.vulkanmod.render.vertex.format.I32_SNorm;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class TerrainBufferBuilder
implements class_4588 {
    private static final Logger LOGGER = Initializer.LOGGER;
    private static final MemoryUtil.MemoryAllocator ALLOCATOR = MemoryUtil.getAllocator((boolean)false);
    private int capacity;
    private int vertexSize;
    protected long bufferPtr;
    protected int nextElementByte;
    int vertices;
    private long elementPtr;
    private VertexBuilder vertexBuilder;

    public TerrainBufferBuilder(int size, int vertexSize, VertexBuilder vertexBuilder) {
        this.bufferPtr = ALLOCATOR.malloc((long)size);
        this.capacity = size;
        this.vertexSize = vertexSize;
        this.vertexBuilder = vertexBuilder;
    }

    public void ensureCapacity() {
        this.ensureCapacity(this.vertexSize * 4);
    }

    private void ensureCapacity(int size) {
        if (this.nextElementByte + size > this.capacity) {
            int capacity = this.capacity;
            int newSize = (capacity + size) * 2;
            this.resize(newSize);
        }
    }

    private void resize(int i) {
        this.bufferPtr = ALLOCATOR.realloc(this.bufferPtr, (long)i);
        LOGGER.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)this.capacity, (Object)i);
        if (this.bufferPtr == 0L) {
            throw new OutOfMemoryError("Failed to resize buffer from " + this.capacity + " bytes to " + i + " bytes");
        }
        this.capacity = i;
    }

    public void endVertex() {
        this.nextElementByte += this.vertexSize;
        ++this.vertices;
    }

    public void vertex(float x, float y, float z, int color, float u, float v, int light, int packedNormal) {
        long ptr = this.bufferPtr + (long)this.nextElementByte;
        this.vertexBuilder.vertex(ptr, x, y, z, color, u, v, light, packedNormal);
        this.endVertex();
    }

    public void end() {
    }

    public void clear() {
        this.nextElementByte = 0;
        this.vertices = 0;
    }

    public ByteBuffer getBuffer() {
        return MemoryUtil.memByteBuffer((long)this.bufferPtr, (int)(this.vertices * this.vertexSize));
    }

    public long getPtr() {
        return this.bufferPtr;
    }

    public int getVertices() {
        return this.vertices;
    }

    public int getNextElementByte() {
        return this.nextElementByte;
    }

    public class_4588 method_22912(float x, float y, float z) {
        this.elementPtr = this.bufferPtr + (long)this.nextElementByte;
        this.endVertex();
        this.vertexBuilder.position(this.elementPtr, x, y, z);
        return this;
    }

    public class_4588 method_1336(int r, int g, int b, int a) {
        int color = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        this.vertexBuilder.color(this.elementPtr, color);
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        this.vertexBuilder.uv(this.elementPtr, u, v);
        return this;
    }

    public class_4588 method_60803(int i) {
        this.vertexBuilder.light(this.elementPtr, i);
        return this;
    }

    public class_4588 method_22914(float f, float g, float h) {
        int packedNormal = I32_SNorm.packNormal(f, g, h);
        this.vertexBuilder.normal(this.elementPtr, packedNormal);
        return this;
    }

    public class_4588 method_60796(int i, int j) {
        return this;
    }

    public class_4588 method_22921(int i, int j) {
        return this;
    }
}

