/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.LongBuffer;
import net.vulkanmod.vulkan.Vulkan;
import net.vulkanmod.vulkan.queue.CommandPool;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDevice;

public class Synchronization {
    private static final int ALLOCATION_SIZE = 50;
    public static final Synchronization INSTANCE = new Synchronization(50);
    private final LongBuffer fences;
    private int idx = 0;
    private ObjectArrayList<CommandPool.CommandBuffer> commandBuffers = new ObjectArrayList();

    Synchronization(int allocSize) {
        this.fences = MemoryUtil.memAllocLong((int)allocSize);
    }

    public synchronized void addCommandBuffer(CommandPool.CommandBuffer commandBuffer) {
        this.addFence(commandBuffer.getFence());
        this.commandBuffers.add((Object)commandBuffer);
    }

    public synchronized void addFence(long fence) {
        if (this.idx == 50) {
            this.waitFences();
        }
        this.fences.put(this.idx, fence);
        ++this.idx;
    }

    public synchronized void waitFences() {
        if (this.idx == 0) {
            return;
        }
        VkDevice device = Vulkan.getVkDevice();
        this.fences.limit(this.idx);
        VK10.vkWaitForFences((VkDevice)device, (LongBuffer)this.fences, (boolean)true, (long)-1L);
        this.commandBuffers.forEach(CommandPool.CommandBuffer::reset);
        this.commandBuffers.clear();
        this.fences.limit(50);
        this.idx = 0;
    }

    public static void waitFence(long fence) {
        VkDevice device = Vulkan.getVkDevice();
        VK10.vkWaitForFences((VkDevice)device, (long)fence, (boolean)true, (long)-1L);
    }

    public static boolean checkFenceStatus(long fence) {
        VkDevice device = Vulkan.getVkDevice();
        return VK10.vkGetFenceStatus((VkDevice)device, (long)fence) == 0;
    }
}

