/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.framebuffer;

import it.unimi.dsi.fastutil.objects.Reference2LongArrayMap;
import java.nio.LongBuffer;
import java.util.Arrays;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.Vulkan;
import net.vulkanmod.vulkan.framebuffer.RenderPass;
import net.vulkanmod.vulkan.memory.MemoryManager;
import net.vulkanmod.vulkan.texture.VulkanImage;
import org.apache.commons.lang3.Validate;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkFramebufferCreateInfo;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkViewport;

public class Framebuffer {
    public static final int DEFAULT_FORMAT = 37;
    protected int format;
    protected int depthFormat;
    protected int width;
    protected int height;
    protected boolean linearFiltering;
    protected boolean depthLinearFiltering;
    protected int attachmentCount;
    boolean hasColorAttachment;
    boolean hasDepthAttachment;
    private VulkanImage colorAttachment;
    protected VulkanImage depthAttachment;
    private final Reference2LongArrayMap<RenderPass> renderpassToFramebufferMap = new Reference2LongArrayMap();

    protected Framebuffer() {
    }

    public Framebuffer(Builder builder) {
        this.format = builder.format;
        this.depthFormat = builder.depthFormat;
        this.width = builder.width;
        this.height = builder.height;
        this.linearFiltering = builder.linearFiltering;
        this.depthLinearFiltering = builder.depthLinearFiltering;
        this.hasColorAttachment = builder.hasColorAttachment;
        this.hasDepthAttachment = builder.hasDepthAttachment;
        if (builder.createImages) {
            this.createImages();
        } else {
            this.colorAttachment = builder.colorAttachment;
            this.depthAttachment = builder.depthAttachment;
        }
    }

    public void createImages() {
        if (this.hasColorAttachment) {
            this.colorAttachment = VulkanImage.builder(this.width, this.height).setFormat(this.format).setUsage(20).setLinearFiltering(this.linearFiltering).setClamp(true).createVulkanImage();
        }
        if (this.hasDepthAttachment) {
            this.depthAttachment = VulkanImage.createDepthImage(this.depthFormat, this.width, this.height, 36, this.depthLinearFiltering, true);
            ++this.attachmentCount;
        }
    }

    public void resize(int newWidth, int newHeight) {
        this.width = newWidth;
        this.height = newHeight;
        this.cleanUp();
        this.createImages();
    }

    private long createFramebuffer(RenderPass renderPass) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer attachments;
            if (this.colorAttachment != null && this.depthAttachment != null) {
                attachments = stack.longs(this.colorAttachment.getImageView(), this.depthAttachment.getImageView());
            } else if (this.colorAttachment != null) {
                attachments = stack.longs(this.colorAttachment.getImageView());
            } else {
                throw new IllegalStateException();
            }
            LongBuffer pFramebuffer = stack.mallocLong(1);
            VkFramebufferCreateInfo framebufferInfo = VkFramebufferCreateInfo.calloc((MemoryStack)stack);
            framebufferInfo.sType$Default();
            framebufferInfo.renderPass(renderPass.getId());
            framebufferInfo.width(this.width);
            framebufferInfo.height(this.height);
            framebufferInfo.layers(1);
            framebufferInfo.pAttachments(attachments);
            if (VK10.vkCreateFramebuffer((VkDevice)Vulkan.getVkDevice(), (VkFramebufferCreateInfo)framebufferInfo, null, (LongBuffer)pFramebuffer) != 0) {
                throw new RuntimeException("Failed to create framebuffer");
            }
            long l = pFramebuffer.get(0);
            return l;
        }
    }

    public void beginRenderPass(VkCommandBuffer commandBuffer, RenderPass renderPass, MemoryStack stack) {
        long framebufferId = this.getFramebufferId(renderPass);
        renderPass.beginRenderPass(commandBuffer, framebufferId, stack);
        Renderer.getInstance().setBoundRenderPass(renderPass);
        Renderer.getInstance().setBoundFramebuffer(this);
        Renderer.setViewportState(0, 0, this.width, this.height);
        Renderer.setScissor(0, 0, this.width, this.height);
    }

    protected long getFramebufferId(RenderPass renderPass) {
        return this.renderpassToFramebufferMap.computeIfAbsent((Object)renderPass, renderPass1 -> this.createFramebuffer(renderPass));
    }

    public VkViewport.Buffer viewport(MemoryStack stack) {
        VkViewport.Buffer viewport = VkViewport.malloc((int)1, (MemoryStack)stack);
        viewport.x(0.0f);
        viewport.y((float)this.height);
        viewport.width((float)this.width);
        viewport.height((float)(-this.height));
        viewport.minDepth(0.0f);
        viewport.maxDepth(1.0f);
        return viewport;
    }

    public VkRect2D.Buffer scissor(MemoryStack stack) {
        VkRect2D.Buffer scissor = VkRect2D.malloc((int)1, (MemoryStack)stack);
        scissor.offset().set(0, 0);
        scissor.extent().set(this.width, this.height);
        return scissor;
    }

    public void cleanUp() {
        this.cleanUp(true);
    }

    public void cleanUp(boolean cleanImages) {
        if (cleanImages) {
            if (this.colorAttachment != null) {
                this.colorAttachment.free();
            }
            if (this.depthAttachment != null) {
                this.depthAttachment.free();
            }
        }
        VkDevice device = Vulkan.getVkDevice();
        long[] ids = this.renderpassToFramebufferMap.values().toLongArray();
        MemoryManager.getInstance().addFrameOp(() -> Arrays.stream(ids).forEach(id -> VK10.vkDestroyFramebuffer((VkDevice)device, (long)id, null)));
        this.renderpassToFramebufferMap.clear();
    }

    public long getDepthImageView() {
        return this.depthAttachment.getImageView();
    }

    public VulkanImage getDepthAttachment() {
        return this.depthAttachment;
    }

    public VulkanImage getColorAttachment() {
        return this.colorAttachment;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFormat() {
        return this.format;
    }

    public int getDepthFormat() {
        return this.depthFormat;
    }

    public static Builder builder(int width, int height, int colorAttachments, boolean hasDepthAttachment) {
        return new Builder(width, height, colorAttachments, hasDepthAttachment);
    }

    public static Builder builder(VulkanImage colorAttachment, VulkanImage depthAttachment) {
        return new Builder(colorAttachment, depthAttachment);
    }

    public static class Builder {
        final boolean createImages;
        final int width;
        final int height;
        int format;
        int depthFormat;
        VulkanImage colorAttachment;
        VulkanImage depthAttachment;
        boolean hasColorAttachment;
        boolean hasDepthAttachment;
        boolean linearFiltering;
        boolean depthLinearFiltering;

        public Builder(int width, int height, int colorAttachments, boolean hasDepthAttachment) {
            Validate.isTrue((colorAttachments > 0 || hasDepthAttachment ? 1 : 0) != 0, (String)"At least 1 attachment needed", (Object[])new Object[0]);
            Validate.isTrue((colorAttachments <= 1 ? 1 : 0) != 0, (String)"Not supported", (Object[])new Object[0]);
            this.createImages = true;
            this.format = 37;
            this.depthFormat = Vulkan.getDefaultDepthFormat();
            this.linearFiltering = true;
            this.depthLinearFiltering = false;
            this.width = width;
            this.height = height;
            this.hasColorAttachment = colorAttachments == 1;
            this.hasDepthAttachment = hasDepthAttachment;
        }

        public Builder(VulkanImage colorAttachment, VulkanImage depthAttachment) {
            this.createImages = false;
            this.colorAttachment = colorAttachment;
            this.depthAttachment = depthAttachment;
            this.format = colorAttachment.format;
            this.width = colorAttachment.width;
            this.height = colorAttachment.height;
            this.hasColorAttachment = true;
            this.hasDepthAttachment = depthAttachment != null;
            this.depthFormat = this.hasDepthAttachment ? depthAttachment.format : 0;
            this.linearFiltering = true;
            this.depthLinearFiltering = false;
        }

        public Framebuffer build() {
            return new Framebuffer(this);
        }

        public Builder setFormat(int format) {
            this.format = format;
            return this;
        }

        public Builder setLinearFiltering(boolean b) {
            this.linearFiltering = b;
            return this;
        }

        public Builder setDepthLinearFiltering(boolean b) {
            this.depthLinearFiltering = b;
            return this;
        }
    }
}

