/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.memory;

import java.nio.ByteBuffer;
import net.vulkanmod.vulkan.Synchronization;
import net.vulkanmod.vulkan.Vulkan;
import net.vulkanmod.vulkan.device.DeviceManager;
import net.vulkanmod.vulkan.memory.Buffer;
import net.vulkanmod.vulkan.memory.MemoryManager;
import net.vulkanmod.vulkan.memory.MemoryType;
import net.vulkanmod.vulkan.memory.StagingBuffer;
import net.vulkanmod.vulkan.queue.CommandPool;
import net.vulkanmod.vulkan.queue.TransferQueue;

public class IndirectBuffer
extends Buffer {
    CommandPool.CommandBuffer commandBuffer;

    public IndirectBuffer(int size, MemoryType type) {
        super(256, type);
        this.createBuffer(size);
    }

    public void recordCopyCmd(ByteBuffer byteBuffer) {
        int size = byteBuffer.remaining();
        if ((long)size > this.bufferSize - this.usedBytes) {
            this.resizeBuffer();
        }
        if (this.type.mappable()) {
            this.type.copyToBuffer(this, size, byteBuffer);
        } else {
            if (this.commandBuffer == null) {
                this.commandBuffer = DeviceManager.getTransferQueue().beginCommands();
            }
            StagingBuffer stagingBuffer = Vulkan.getStagingBuffer();
            stagingBuffer.copyBuffer(size, byteBuffer);
            TransferQueue.uploadBufferCmd(this.commandBuffer.getHandle(), stagingBuffer.id, stagingBuffer.offset, this.getId(), this.getUsedBytes(), size);
        }
        this.offset = this.usedBytes;
        this.usedBytes += (long)size;
    }

    private void resizeBuffer() {
        MemoryManager.getInstance().addToFreeable(this);
        long newSize = this.bufferSize + (this.bufferSize >> 1);
        this.createBuffer(newSize);
        this.usedBytes = 0L;
    }

    public void submitUploads() {
        if (this.commandBuffer == null) {
            return;
        }
        DeviceManager.getTransferQueue().submitCommands(this.commandBuffer);
        Synchronization.INSTANCE.addCommandBuffer(this.commandBuffer);
        this.commandBuffer = null;
    }
}

