/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.config.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public abstract class GuiRenderer {
    public static class_310 minecraft;
    public static class_327 font;
    public static class_332 guiGraphics;
    public static class_4587 pose;
    public static class_287 bufferBuilder;
    public static boolean batching;

    public static void setPoseStack(class_4587 poseStack) {
        pose = poseStack;
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static void enableScissor(int x, int y, int width, int height) {
        class_1041 window = class_310.method_1551().method_22683();
        int wHeight = window.method_4506();
        double scale = window.method_4495();
        int xScaled = (int)((double)x * scale);
        int yScaled = (int)((double)wHeight - (double)(y + height) * scale);
        int widthScaled = (int)((double)width * scale);
        int heightScaled = (int)((double)height * scale);
        RenderSystem.enableScissor((int)xScaled, (int)yScaled, (int)Math.max(0, widthScaled), (int)Math.max(0, heightScaled));
    }

    public static void fillBox(float x0, float y0, float width, float height, int color) {
        GuiRenderer.fill(x0, y0, x0 + width, y0 + height, 0.0f, color);
    }

    public static void fill(float x0, float y0, float x1, float y1, int color) {
        GuiRenderer.fill(x0, y0, x1, y1, 0.0f, color);
    }

    public static void fill(float x0, float y0, float x1, float y1, float z, int color) {
        Matrix4f matrix4f = pose.method_23760().method_23761();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        if (!batching) {
            bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        }
        bufferBuilder.method_22918(matrix4f, x0, y0, z).method_39415(color);
        bufferBuilder.method_22918(matrix4f, x0, y1, z).method_39415(color);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_39415(color);
        bufferBuilder.method_22918(matrix4f, x1, y0, z).method_39415(color);
        if (!batching) {
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
    }

    public static void fillGradient(float x0, float y0, float x1, float y1, int color1, int color2) {
        GuiRenderer.fillGradient(x0, y0, x1, y1, 0.0f, color1, color2);
    }

    public static void fillGradient(float x0, float y0, float x1, float y1, float z, int color1, int color2) {
        Matrix4f matrix4f = pose.method_23760().method_23761();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        if (!batching) {
            bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        }
        bufferBuilder.method_22918(matrix4f, x0, y0, z).method_39415(color1);
        bufferBuilder.method_22918(matrix4f, x0, y1, z).method_39415(color2);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_39415(color2);
        bufferBuilder.method_22918(matrix4f, x1, y0, z).method_39415(color1);
        if (!batching) {
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
    }

    public static void renderBoxBorder(float x0, float y0, float width, float height, float borderWidth, int color) {
        GuiRenderer.renderBorder(x0, y0, x0 + width, y0 + height, borderWidth, color);
    }

    public static void renderBorder(float x0, float y0, float x1, float y1, float width, int color) {
        GuiRenderer.fill(x0, y0, x1, y0 + width, color);
        GuiRenderer.fill(x0, y1 - width, x1, y1, color);
        GuiRenderer.fill(x0, y0 + width, x0 + width, y1 - width, color);
        GuiRenderer.fill(x1 - width, y0 + width, x1, y1 - width, color);
    }

    public static void drawString(class_327 font, class_2561 component, int x, int y, int color) {
        GuiRenderer.drawString(font, component.method_30937(), x, y, color);
    }

    public static void drawString(class_327 font, class_5481 formattedCharSequence, int x, int y, int color) {
        guiGraphics.method_35720(font, formattedCharSequence, x, y, color);
    }

    public static void drawString(class_327 font, class_2561 component, int x, int y, int color, boolean shadow) {
        GuiRenderer.drawString(font, component.method_30937(), x, y, color, shadow);
    }

    public static void drawString(class_327 font, class_5481 formattedCharSequence, int x, int y, int color, boolean shadow) {
        guiGraphics.method_51430(font, formattedCharSequence, x, y, color, shadow);
    }

    public static void drawCenteredString(class_327 font, class_2561 component, int x, int y, int color) {
        class_5481 formattedCharSequence = component.method_30937();
        guiGraphics.method_35720(font, formattedCharSequence, x - font.method_30880(formattedCharSequence) / 2, y, color);
    }

    public static int getMaxTextWidth(class_327 font, List<class_5481> list) {
        int maxWidth = 0;
        for (class_5481 text : list) {
            int width = font.method_30880(text);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public static void beginBatch(class_293.class_5596 mode, class_293 format) {
        bufferBuilder = class_289.method_1348().method_60827(mode, format);
        batching = true;
    }

    public static void endBatch() {
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        batching = false;
    }

    static {
        batching = false;
    }
}

