/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.mixin.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.jtracy.Plot;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.vulkanmod.gl.GlBuffer;
import net.vulkanmod.gl.GlFramebuffer;
import net.vulkanmod.gl.GlRenderbuffer;
import net.vulkanmod.gl.GlShader;
import net.vulkanmod.gl.GlTexture;
import net.vulkanmod.vulkan.Renderer;
import net.vulkanmod.vulkan.VRenderSystem;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={GlStateManager.class})
public class GlStateManagerM {
    @Shadow
    @Final
    private static Plot PLOT_BUFFERS;
    @Shadow
    private static int numBuffers;

    @Overwrite(remap=false)
    public static void _bindTexture(int i) {
        GlTexture.bindTexture(i);
    }

    @Overwrite(remap=false)
    public static void _disableBlend() {
        RenderSystem.assertOnRenderThread();
        VRenderSystem.disableBlend();
    }

    @Overwrite(remap=false)
    public static void _enableBlend() {
        RenderSystem.assertOnRenderThread();
        VRenderSystem.enableBlend();
    }

    @Overwrite(remap=false)
    public static void _blendFunc(int i, int j) {
        RenderSystem.assertOnRenderThread();
        VRenderSystem.blendFunc(i, j);
    }

    @Overwrite(remap=false)
    public static void _blendFuncSeparate(int i, int j, int k, int l) {
        RenderSystem.assertOnRenderThread();
        VRenderSystem.blendFuncSeparate(i, j, k, l);
    }

    @Overwrite(remap=false)
    public static void _disableScissorTest() {
        Renderer.resetScissor();
    }

    @Overwrite(remap=false)
    public static void _enableScissorTest() {
    }

    @Overwrite(remap=false)
    public static void _enableCull() {
        VRenderSystem.enableCull();
    }

    @Overwrite(remap=false)
    public static void _disableCull() {
        VRenderSystem.disableCull();
    }

    @Redirect(method={"_viewport"}, at=@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glViewport(IIII)V"), remap=false)
    private static void _viewport(int x, int y, int width, int height) {
        Renderer.setViewport(x, y, width, height);
    }

    @Overwrite(remap=false)
    public static void _scissorBox(int x, int y, int width, int height) {
        Renderer.setScissor(x, y, width, height);
    }

    @Overwrite(remap=false)
    public static int _getError() {
        return 0;
    }

    @Overwrite(remap=false)
    public static void _texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, @Nullable IntBuffer pixels) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlTexture.texImage2D(target, level, internalFormat, width, height, border, format, type, pixels != null ? MemoryUtil.memByteBuffer((IntBuffer)pixels) : null);
    }

    @Overwrite(remap=false)
    public static void _texSubImage2D(int target, int level, int offsetX, int offsetY, int width, int height, int format, int type, long pixels) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlTexture.texSubImage2D(target, level, offsetX, offsetY, width, height, format, type, pixels);
    }

    @Overwrite(remap=false)
    public static void _activeTexture(int i) {
        GlTexture.activeTexture(i);
    }

    @Overwrite(remap=false)
    public static void _texParameter(int i, int j, int k) {
        GlTexture.texParameteri(i, j, k);
    }

    @Overwrite(remap=false)
    public static void _texParameter(int i, int j, float k) {
    }

    @Overwrite(remap=false)
    public static int _getTexLevelParameter(int i, int j, int k) {
        return GlTexture.getTexLevelParameter(i, j, k);
    }

    @Overwrite(remap=false)
    public static void _pixelStore(int pname, int param) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlTexture.pixelStoreI(pname, param);
    }

    @Overwrite(remap=false)
    public static int _genTexture() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GlTexture.genTextureId();
    }

    @Overwrite(remap=false)
    public static void _deleteTexture(int i) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlTexture.glDeleteTextures(i);
    }

    @Overwrite(remap=false)
    public static void _colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        RenderSystem.assertOnRenderThread();
        VRenderSystem.colorMask(red, green, blue, alpha);
    }

    @Overwrite(remap=false)
    public static void _depthFunc(int i) {
        RenderSystem.assertOnRenderThreadOrInit();
        VRenderSystem.depthFunc(i);
    }

    @Overwrite(remap=false)
    public static void _clearColor(float f, float g, float h, float i) {
        RenderSystem.assertOnRenderThreadOrInit();
        VRenderSystem.setClearColor(f, g, h, i);
    }

    @Overwrite(remap=false)
    public static void _clearDepth(double d) {
    }

    @Overwrite(remap=false)
    public static void _clear(int mask) {
        RenderSystem.assertOnRenderThreadOrInit();
        VRenderSystem.clear(mask);
    }

    @Overwrite(remap=false)
    public static void _disableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        VRenderSystem.disableDepthTest();
    }

    @Overwrite(remap=false)
    public static void _enableDepthTest() {
        RenderSystem.assertOnRenderThreadOrInit();
        VRenderSystem.enableDepthTest();
    }

    @Overwrite(remap=false)
    public static void _depthMask(boolean bl) {
        RenderSystem.assertOnRenderThread();
        VRenderSystem.depthMask(bl);
    }

    @Overwrite(remap=false)
    public static int glGenFramebuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GlFramebuffer.genFramebufferId();
    }

    @Overwrite(remap=false)
    public static int glGenRenderbuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GlRenderbuffer.genId();
    }

    @Overwrite(remap=false)
    public static void _glBindFramebuffer(int i, int j) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlFramebuffer.bindFramebuffer(i, j);
    }

    @Overwrite(remap=false)
    public static void _glFramebufferTexture2D(int i, int j, int k, int l, int m) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlFramebuffer.framebufferTexture2D(i, j, k, l, m);
    }

    @Overwrite(remap=false)
    public static void _glBindRenderbuffer(int i, int j) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlRenderbuffer.bindRenderbuffer(i, j);
    }

    @Overwrite(remap=false)
    public static void _glFramebufferRenderbuffer(int i, int j, int k, int l) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlFramebuffer.framebufferRenderbuffer(i, j, k, l);
    }

    @Overwrite(remap=false)
    public static void _glRenderbufferStorage(int i, int j, int k, int l) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlRenderbuffer.renderbufferStorage(i, j, k, l);
    }

    @Overwrite(remap=false)
    public static int glCheckFramebufferStatus(int i) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GlFramebuffer.glCheckFramebufferStatus(i);
    }

    @Overwrite(remap=false)
    public static int _glGenBuffers() {
        RenderSystem.assertOnRenderThreadOrInit();
        PLOT_BUFFERS.setValue((double)(++numBuffers));
        return GlBuffer.glGenBuffers();
    }

    @Overwrite(remap=false)
    public static void _glBindBuffer(int i, int j) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlBuffer.glBindBuffer(i, j);
    }

    @Overwrite(remap=false)
    public static void _glBufferData(int i, ByteBuffer byteBuffer, int j) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlBuffer.glBufferData(i, byteBuffer, j);
    }

    @Overwrite(remap=false)
    public static void _glBufferData(int i, long l, int j) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlBuffer.glBufferData(i, l, j);
    }

    @Overwrite(remap=false)
    @Nullable
    public static ByteBuffer _glMapBuffer(int i, int j) {
        RenderSystem.assertOnRenderThreadOrInit();
        return GlBuffer.glMapBuffer(i, j);
    }

    @Overwrite(remap=false)
    public static void _glUnmapBuffer(int i) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlBuffer.glUnmapBuffer(i);
    }

    @Overwrite(remap=false)
    public static void _glDeleteBuffers(int i) {
        RenderSystem.assertOnRenderThread();
        GlBuffer.glDeleteBuffers(i);
    }

    @Overwrite(remap=false)
    public static void _disableVertexAttribArray(int i) {
    }

    @Overwrite(remap=false)
    public static void glDeleteShader(int i) {
        RenderSystem.assertOnRenderThread();
        GlShader.glDeleteShader(i);
    }

    @Overwrite(remap=false)
    public static int glCreateShader(int i) {
        RenderSystem.assertOnRenderThread();
        return GlShader.glCreateShader(i);
    }

    @Overwrite(remap=false)
    public static void glShaderSource(int i, String string) {
        RenderSystem.assertOnRenderThread();
        GlShader.glShaderSource(i, string);
    }

    @Overwrite(remap=false)
    public static void glCompileShader(int i) {
        RenderSystem.assertOnRenderThread();
        GlShader.glCompileShader(i);
    }

    @Overwrite(remap=false)
    public static int glGetShaderi(int i, int j) {
        RenderSystem.assertOnRenderThread();
        return GlShader.glGetShaderi(i, j);
    }

    @Overwrite(remap=false)
    public static void _glUseProgram(int i) {
    }

    @Overwrite(remap=false)
    public static int glCreateProgram() {
        return 0;
    }

    @Overwrite(remap=false)
    public static void glDeleteProgram(int i) {
    }
}

