/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.vulkanmod.render.chunk.build.thread.ThreadBuilderPack;
import net.vulkanmod.render.shader.ShaderLoadUtil;
import net.vulkanmod.render.vertex.CustomVertexFormat;
import net.vulkanmod.render.vertex.TerrainRenderType;
import net.vulkanmod.vulkan.shader.GraphicsPipeline;
import net.vulkanmod.vulkan.shader.Pipeline;

public abstract class PipelineManager {
    public static class_293 terrainVertexFormat;
    static GraphicsPipeline terrainShader;
    static GraphicsPipeline terrainShaderEarlyZ;
    static GraphicsPipeline fastBlitPipeline;
    static GraphicsPipeline cloudsPipeline;
    private static Function<TerrainRenderType, GraphicsPipeline> shaderGetter;

    public static void setTerrainVertexFormat(class_293 format) {
        terrainVertexFormat = format;
    }

    public static void init() {
        PipelineManager.setTerrainVertexFormat(CustomVertexFormat.COMPRESSED_TERRAIN);
        PipelineManager.createBasicPipelines();
        PipelineManager.setDefaultShader();
        ThreadBuilderPack.defaultTerrainBuilderConstructor();
    }

    public static void setDefaultShader() {
        PipelineManager.setShaderGetter(renderType -> renderType == TerrainRenderType.TRANSLUCENT ? terrainShaderEarlyZ : terrainShader);
    }

    private static void createBasicPipelines() {
        terrainShaderEarlyZ = PipelineManager.createPipeline("terrain_earlyZ", terrainVertexFormat);
        terrainShader = PipelineManager.createPipeline("terrain", terrainVertexFormat);
        fastBlitPipeline = PipelineManager.createPipeline("blit", CustomVertexFormat.NONE);
        cloudsPipeline = PipelineManager.createPipeline("clouds", class_290.field_1576);
    }

    private static GraphicsPipeline createPipeline(String configName, class_293 vertexFormat) {
        Pipeline.Builder pipelineBuilder = new Pipeline.Builder(vertexFormat, configName);
        JsonObject config = ShaderLoadUtil.getJsonConfig("basic", configName);
        pipelineBuilder.parseBindings(config);
        ShaderLoadUtil.loadShaders(pipelineBuilder, config, configName, "basic");
        return pipelineBuilder.createGraphicsPipeline();
    }

    public static GraphicsPipeline getTerrainShader(TerrainRenderType renderType) {
        return shaderGetter.apply(renderType);
    }

    public static void setShaderGetter(Function<TerrainRenderType, GraphicsPipeline> consumer) {
        shaderGetter = consumer;
    }

    public static GraphicsPipeline getTerrainDirectShader(class_1921 renderType) {
        return terrainShader;
    }

    public static GraphicsPipeline getTerrainIndirectShader(class_1921 renderType) {
        return terrainShaderEarlyZ;
    }

    public static GraphicsPipeline getFastBlitPipeline() {
        return fastBlitPipeline;
    }

    public static GraphicsPipeline getCloudsPipeline() {
        return cloudsPipeline;
    }

    public static void destroyPipelines() {
        terrainShaderEarlyZ.cleanUp();
        terrainShader.cleanUp();
        fastBlitPipeline.cleanUp();
        cloudsPipeline.cleanUp();
    }
}

