/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.chunk.build;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_2841;
import net.minecraft.class_2891;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_6539;
import net.vulkanmod.render.chunk.build.biome.BiomeData;
import net.vulkanmod.render.chunk.build.color.TintCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderRegion
implements class_1920,
RenderAttachedBlockView {
    public static final int WIDTH = 3;
    public static final int SIZE = 27;
    public static final int BOUNDARY_BLOCK_WIDTH = 2;
    public static final int REGION_BLOCK_WIDTH = 20;
    public static final int BLOCK_COUNT = 8000;
    public static final class_2680 AIR_BLOCK_STATE = class_2246.field_10124.method_9564();
    private final int minSecX;
    private final int minSecY;
    private final int minSecZ;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final class_1937 level;
    private final int blendRadius;
    private final class_2841<class_2680>[] blockDataContainers;
    private final class_2680[] blockData;
    private final class_2804[][] lightData;
    private BiomeData biomeData;
    private TintCache tintCache;
    private final Map<class_2338, class_2586> blockEntityMap;
    private final Function<class_2338, class_2680> blockStateGetter;

    RenderRegion(class_1937 level, int x, int y, int z, class_2841<class_2680>[] blockData, class_2804[][] lightData, BiomeData biomeData, Map<class_2338, class_2586> blockEntityMap) {
        this.level = level;
        this.minSecX = x - 1;
        this.minSecY = y - 1;
        this.minSecZ = z - 1;
        this.minX = (this.minSecX << 4) + 16 - 2;
        this.minZ = (this.minSecZ << 4) + 16 - 2;
        this.minY = (this.minSecY << 4) + 16 - 2;
        this.maxX = this.minX + 20;
        this.maxZ = this.minZ + 20;
        this.maxY = this.minY + 20;
        this.blockDataContainers = blockData;
        this.lightData = lightData;
        this.biomeData = biomeData;
        this.blockEntityMap = blockEntityMap;
        this.blockData = new class_2680[8000];
        this.blockStateGetter = level.method_27982() ? this::debugBlockState : this::defaultBlockState;
        this.blendRadius = (Integer)class_310.method_1551().field_1690.method_41805().method_41753();
    }

    public void loadBlockStates() {
        Arrays.fill(this.blockData, class_2246.field_10124.method_9564());
        for (int x = 0; x <= 2; ++x) {
            for (int z = 0; z <= 2; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    int idx = this.getSectionIdx(x, y, z);
                    class_2841<class_2680> container = this.blockDataContainers[idx];
                    if (container == null) continue;
                    int absBlockX = x + this.minSecX << 4;
                    int absBlockY = y + this.minSecY << 4;
                    int absBlockZ = z + this.minSecZ << 4;
                    int tMinX = Math.max(this.minX, absBlockX);
                    int tMinY = Math.max(this.minY, absBlockY);
                    int tMinZ = Math.max(this.minZ, absBlockZ);
                    int tMaxX = Math.min(this.maxX, absBlockX + 16);
                    int tMaxY = Math.min(this.maxY, absBlockY + 16);
                    int tMaxZ = Math.min(this.maxZ, absBlockZ + 16);
                    this.loadSectionBlockStates(container, this.blockData, tMinX, tMinY, tMinZ, tMaxX, tMaxY, tMaxZ);
                }
            }
        }
    }

    void loadSectionBlockStates(class_2841<class_2680> container, class_2680[] blockStates, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int y = minY; y < maxY; ++y) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    int idx = this.getBlockIdx(x - this.minX, y - this.minY, z - this.minZ);
                    blockStates[idx] = container != null ? (class_2680)container.method_12321(x & 0xF, y & 0xF, z & 0xF) : class_2246.field_10124.method_9564();
                }
            }
        }
    }

    public void initTintCache(TintCache tintCache) {
        this.tintCache = tintCache;
        this.tintCache.init(this.biomeData, this.blendRadius, this.minSecX + 1, this.minSecY + 1, this.minSecZ + 1);
    }

    public class_2680 method_8320(class_2338 blockPos) {
        return this.blockStateGetter.apply(blockPos);
    }

    public class_3610 method_8316(class_2338 blockPos) {
        return this.method_8320(blockPos).method_26227();
    }

    public float method_24852(class_2350 direction, boolean bl) {
        return this.level.method_24852(direction, bl);
    }

    public class_3568 method_22336() {
        return this.level.method_22336();
    }

    public int method_8314(class_1944 lightLayer, class_2338 blockPos) {
        int secZ;
        int secY;
        if (this.outsideRegion(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())) {
            return 0;
        }
        int secX = class_4076.method_18675((int)blockPos.method_10263()) - this.minSecX;
        class_2804 dataLayer = this.lightData[this.getSectionIdx(secX, secY = class_4076.method_18675((int)blockPos.method_10264()) - this.minSecY, secZ = class_4076.method_18675((int)blockPos.method_10260()) - this.minSecZ)][lightLayer.ordinal()];
        return dataLayer == null ? 0 : dataLayer.method_12139(blockPos.method_10263() & 0xF, blockPos.method_10264() & 0xF, blockPos.method_10260() & 0xF);
    }

    public int method_22335(class_2338 blockPos, int i) {
        if (this.outsideRegion(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())) {
            return 0;
        }
        int secX = class_4076.method_18675((int)blockPos.method_10263()) - this.minSecX;
        int secY = class_4076.method_18675((int)blockPos.method_10264()) - this.minSecY;
        int secZ = class_4076.method_18675((int)blockPos.method_10260()) - this.minSecZ;
        class_2804[] dataLayers = this.lightData[this.getSectionIdx(secX, secY, secZ)];
        class_2804 skyLightLayer = dataLayers[class_1944.field_9284.ordinal()];
        class_2804 blockLightLayer = dataLayers[class_1944.field_9282.ordinal()];
        int relX = blockPos.method_10263() & 0xF;
        int relY = blockPos.method_10264() & 0xF;
        int relZ = blockPos.method_10260() & 0xF;
        int skyLight = skyLightLayer == null ? 0 : skyLightLayer.method_12139(relX, relY, relZ) - i;
        int blockLight = blockLightLayer == null ? 0 : blockLightLayer.method_12139(relX, relY, relZ);
        return Math.max(skyLight, blockLight);
    }

    @Nullable
    public class_2586 method_8321(@NotNull class_2338 blockPos) {
        return this.blockEntityMap.get(blockPos);
    }

    public int method_23752(class_2338 blockPos, class_6539 colorResolver) {
        return this.tintCache.getColor(blockPos, colorResolver);
    }

    public int method_31607() {
        return this.level.method_31607();
    }

    public int method_31605() {
        return this.level.method_31605();
    }

    public int getSectionIdx(int secX, int secY, int secZ) {
        return 3 * (3 * secY + secZ) + secX;
    }

    public int getBlockIdx(int x, int y, int z) {
        return 20 * (20 * y + z) + x;
    }

    public boolean outsideRegion(int x, int y, int z) {
        return x < this.minX || x >= this.maxX || y < this.minY || y >= this.maxY || z < this.minZ || z >= this.maxZ;
    }

    public class_2680 defaultBlockState(class_2338 blockPos) {
        int z;
        int y;
        int x = blockPos.method_10263();
        if (this.outsideRegion(x, y = blockPos.method_10264(), z = blockPos.method_10260())) {
            return AIR_BLOCK_STATE;
        }
        return this.blockData[this.getBlockIdx(x -= this.minX, y -= this.minY, z -= this.minZ)];
    }

    public class_2680 debugBlockState(class_2338 blockPos) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        class_2680 blockState = null;
        if (y == 60) {
            blockState = class_2246.field_10499.method_9564();
        } else if (y == 70) {
            blockState = class_2891.method_12578((int)x, (int)z);
        }
        return blockState == null ? class_2246.field_10124.method_9564() : blockState;
    }
}

