/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.util;

import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Arrays;

public class SortUtil {
    public static void mergeSort(int[] a, float[] distances) {
        SortUtil.mergeSort(a, distances, 0, a.length, null);
    }

    public static void mergeSort(int[] indices, float[] distances, int from, int to, int[] supp) {
        int len = to - from;
        if (len < 16) {
            SortUtil.insertionSort(indices, distances, from, to);
        } else {
            if (supp == null) {
                supp = Arrays.copyOf(indices, to);
            }
            int mid = from + to >>> 1;
            SortUtil.mergeSort(supp, distances, from, mid, indices);
            SortUtil.mergeSort(supp, distances, mid, to, indices);
            if (Float.compare(distances[supp[mid]], distances[supp[mid - 1]]) <= 0) {
                System.arraycopy(supp, from, indices, from, len);
            } else {
                int p = from;
                int q = mid;
                for (int i = from; i < to; ++i) {
                    indices[i] = q < to && (p >= mid || Float.compare(distances[supp[q]], distances[supp[p]]) > 0) ? supp[q++] : supp[p++];
                }
            }
        }
    }

    public static void quickSort(int[] a, float[] distances) {
        SortUtil.quickSort(a, distances, 0, a.length);
    }

    public static void quickSort(int[] is, float[] distances, int from, int to) {
        int len = to - from;
        if (len >= 16) {
            int c;
            int m = from + len / 2;
            int l = from;
            int n = to - 1;
            int ab = Float.compare(distances[is[l]], distances[is[m]]);
            int ac = Float.compare(distances[is[l]], distances[is[n]]);
            int bc = Float.compare(distances[is[m]], distances[is[n]]);
            m = ab < 0 ? (bc < 0 ? m : (ac < 0 ? n : l)) : (bc > 0 ? m : (ac > 0 ? n : l));
            int v = is[m];
            int a = from;
            int b = from;
            int d = c = to - 1;
            SortUtil.swap(is, m, d);
            float mValue = distances[v];
            block0: while (b < c) {
                if (Float.compare(distances[is[b]], mValue) > 0) {
                    while (b < c) {
                        if (Float.compare(distances[is[c]], mValue) < 0) {
                            SortUtil.swap(is, b, c);
                            ++b;
                            --c;
                            continue block0;
                        }
                        --c;
                    }
                    continue;
                }
                ++b;
            }
            SortUtil.swap(is, d, b);
            if (b - a > 1) {
                SortUtil.quickSort(is, distances, a, b);
            }
            if (d - b > 1) {
                SortUtil.quickSort(is, distances, b, d);
            }
            return;
        }
        SortUtil.insertionSort(is, distances, from, to);
    }

    private static void insertionSort(int[] is, float[] distances, int from, int to) {
        int i = from;
        while (++i < to) {
            int t = is[i];
            int j = i;
            int u = is[i - 1];
            while (Float.compare(distances[u], distances[t]) < 0) {
                is[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = is[--j - 1];
            }
            is[j] = t;
        }
        return;
    }

    public static void swap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            SortUtil.swap(x, a, b);
            ++b;
            ++i;
            ++a;
        }
    }

    public static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }
}

