/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.render.vertex;

import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.vulkanmod.Initializer;
import net.vulkanmod.interfaces.ExtendedRenderType;
import net.vulkanmod.vulkan.VRenderSystem;

public enum TerrainRenderType {
    SOLID(0.0f),
    CUTOUT_MIPPED(0.5f),
    CUTOUT(0.1f),
    TRANSLUCENT(0.0f),
    TRIPWIRE(0.1f);

    public static final TerrainRenderType[] VALUES;
    public static final EnumSet<TerrainRenderType> COMPACT_RENDER_TYPES;
    public static final EnumSet<TerrainRenderType> SEMI_COMPACT_RENDER_TYPES;
    private static Function<TerrainRenderType, TerrainRenderType> remapper;
    public final float alphaCutout;

    private TerrainRenderType(float alphaCutout) {
        this.alphaCutout = alphaCutout;
    }

    public void setCutoutUniform() {
        VRenderSystem.alphaCutout = this.alphaCutout;
    }

    public static TerrainRenderType get(class_1921 renderType) {
        return ((ExtendedRenderType)renderType).getTerrainRenderType();
    }

    public static TerrainRenderType get(String name) {
        return switch (name) {
            case "solid" -> SOLID;
            case "cutout" -> CUTOUT;
            case "cutout_mipped" -> CUTOUT_MIPPED;
            case "translucent" -> TRANSLUCENT;
            case "tripwire" -> TRIPWIRE;
            default -> null;
        };
    }

    public static class_1921 getRenderType(TerrainRenderType renderType) {
        return switch (renderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_1921.method_23577();
            case 2 -> class_1921.method_23581();
            case 1 -> class_1921.method_23579();
            case 3 -> class_1921.method_23583();
            case 4 -> class_1921.method_29997();
        };
    }

    public static void updateMapping() {
        remapper = Initializer.CONFIG.uniqueOpaqueLayer ? renderType -> switch (renderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> CUTOUT_MIPPED;
            case 3, 4 -> TRANSLUCENT;
        } : renderType -> switch (renderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> CUTOUT_MIPPED;
            case 2 -> CUTOUT;
            case 3, 4 -> TRANSLUCENT;
        };
    }

    public static TerrainRenderType getRemapped(TerrainRenderType renderType) {
        return remapper.apply(renderType);
    }

    static {
        VALUES = TerrainRenderType.values();
        COMPACT_RENDER_TYPES = EnumSet.of(CUTOUT_MIPPED, TRANSLUCENT);
        SEMI_COMPACT_RENDER_TYPES = EnumSet.of(CUTOUT_MIPPED, CUTOUT, TRANSLUCENT);
        SEMI_COMPACT_RENDER_TYPES.add(CUTOUT);
        SEMI_COMPACT_RENDER_TYPES.add(CUTOUT_MIPPED);
        SEMI_COMPACT_RENDER_TYPES.add(TRANSLUCENT);
        COMPACT_RENDER_TYPES.add(CUTOUT_MIPPED);
        COMPACT_RENDER_TYPES.add(TRANSLUCENT);
    }
}

