/*
 * Decompiled with CFR 0.152.
 */
package net.vulkanmod.vulkan.memory;

import java.nio.ByteBuffer;
import net.vulkanmod.vulkan.memory.Buffer;
import net.vulkanmod.vulkan.memory.MemoryManager;
import net.vulkanmod.vulkan.memory.MemoryType;
import net.vulkanmod.vulkan.memory.MemoryTypes;

public class VertexBuffer
extends Buffer {
    public VertexBuffer(int size) {
        this(size, MemoryTypes.HOST_MEM);
    }

    public VertexBuffer(int size, MemoryType type) {
        super(128, type);
        this.createBuffer(size);
    }

    public void copyToVertexBuffer(long vertexSize, long vertexCount, ByteBuffer byteBuffer) {
        int bufferSize = (int)(vertexSize * vertexCount);
        if ((long)bufferSize > this.bufferSize - this.usedBytes) {
            this.resizeBuffer((this.bufferSize + (long)bufferSize) * 2L);
        }
        this.type.copyToBuffer(this, bufferSize, byteBuffer);
        this.offset = this.usedBytes;
        this.usedBytes += (long)bufferSize;
    }

    private void resizeBuffer(long newSize) {
        MemoryManager.getInstance().addToFreeable(this);
        this.createBuffer(newSize);
    }
}

